/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.oauth2.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;


/**
 * Model definition for Userinfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the . For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class Userinfo extends GenericJson {


  /**
   * The user's last name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("family_name")
  private String familyName;



  /**
   * The user's full name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;



  /**
   * URL of the user's picture image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String picture;



  /**
   * The user's default locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String locale;



  /**
   * The user's gender.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String gender;



  /**
   * The user's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String email;



  /**
   * The user's birthday. The year is not present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String birthday;



  /**
   * URL of the profile page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String link;



  /**
   * The user's first name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("given_name")
  private String givenName;



  /**
   * The user's default timezone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timezone;



  /**
   * The focus obfuscated gaia id of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;



  /**
   * Boolean flag which is true if the email address is verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("verified_email")
  private Boolean verifiedEmail;




  /**
   * The user's last name.
   * The value returned may be {@code null}.
   */
  public String getFamilyName() {
    return familyName;
  }

  /**
   * The user's last name.
   * The value set may be {@code null}.
   */
  public Userinfo setFamilyName(String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * The user's full name.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * The user's full name.
   * The value set may be {@code null}.
   */
  public Userinfo setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the user's picture image.
   * The value returned may be {@code null}.
   */
  public String getPicture() {
    return picture;
  }

  /**
   * URL of the user's picture image.
   * The value set may be {@code null}.
   */
  public Userinfo setPicture(String picture) {
    this.picture = picture;
    return this;
  }

  /**
   * The user's default locale.
   * The value returned may be {@code null}.
   */
  public String getLocale() {
    return locale;
  }

  /**
   * The user's default locale.
   * The value set may be {@code null}.
   */
  public Userinfo setLocale(String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * The user's gender.
   * The value returned may be {@code null}.
   */
  public String getGender() {
    return gender;
  }

  /**
   * The user's gender.
   * The value set may be {@code null}.
   */
  public Userinfo setGender(String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * The user's email address.
   * The value returned may be {@code null}.
   */
  public String getEmail() {
    return email;
  }

  /**
   * The user's email address.
   * The value set may be {@code null}.
   */
  public Userinfo setEmail(String email) {
    this.email = email;
    return this;
  }

  /**
   * The user's birthday. The year is not present.
   * The value returned may be {@code null}.
   */
  public String getBirthday() {
    return birthday;
  }

  /**
   * The user's birthday. The year is not present.
   * The value set may be {@code null}.
   */
  public Userinfo setBirthday(String birthday) {
    this.birthday = birthday;
    return this;
  }

  /**
   * URL of the profile page.
   * The value returned may be {@code null}.
   */
  public String getLink() {
    return link;
  }

  /**
   * URL of the profile page.
   * The value set may be {@code null}.
   */
  public Userinfo setLink(String link) {
    this.link = link;
    return this;
  }

  /**
   * The user's first name.
   * The value returned may be {@code null}.
   */
  public String getGivenName() {
    return givenName;
  }

  /**
   * The user's first name.
   * The value set may be {@code null}.
   */
  public Userinfo setGivenName(String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The user's default timezone.
   * The value returned may be {@code null}.
   */
  public String getTimezone() {
    return timezone;
  }

  /**
   * The user's default timezone.
   * The value set may be {@code null}.
   */
  public Userinfo setTimezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * The focus obfuscated gaia id of the user.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The focus obfuscated gaia id of the user.
   * The value set may be {@code null}.
   */
  public Userinfo setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified.
   * The value returned may be {@code null}.
   */
  public Boolean getVerifiedEmail() {
    return verifiedEmail;
  }

  /**
   * Boolean flag which is true if the email address is verified.
   * The value set may be {@code null}.
   */
  public Userinfo setVerifiedEmail(Boolean verifiedEmail) {
    this.verifiedEmail = verifiedEmail;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single {@link Userinfo} would include the response headers,
   * while a request which returns an array of {@link Userinfo}, would have a non-null response
   * header in the enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }












}
