/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * An AdvanceRelocateBucketOperation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdvanceRelocateBucketOperationRequest extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the time when the relocation will revert to the sync stage if the relocation hasn't
   * succeeded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime expireTime;

  /**
   * Specifies the duration after which the relocation will revert to the sync stage if the
   * relocation hasn't succeeded. Optional, if not supplied, a default value of 12h will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * Specifies the time when the relocation will revert to the sync stage if the relocation hasn't
   * succeeded.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getExpireTime() {
    return expireTime;
  }

  /**
   * Specifies the time when the relocation will revert to the sync stage if the relocation hasn't
   * succeeded.
   * @param expireTime expireTime or {@code null} for none
   */
  public AdvanceRelocateBucketOperationRequest setExpireTime(com.google.api.client.util.DateTime expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Specifies the duration after which the relocation will revert to the sync stage if the
   * relocation hasn't succeeded. Optional, if not supplied, a default value of 12h will be used.
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * Specifies the duration after which the relocation will revert to the sync stage if the
   * relocation hasn't succeeded. Optional, if not supplied, a default value of 12h will be used.
   * @param ttl ttl or {@code null} for none
   */
  public AdvanceRelocateBucketOperationRequest setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  @Override
  public AdvanceRelocateBucketOperationRequest set(String fieldName, Object value) {
    return (AdvanceRelocateBucketOperationRequest) super.set(fieldName, value);
  }

  @Override
  public AdvanceRelocateBucketOperationRequest clone() {
    return (AdvanceRelocateBucketOperationRequest) super.clone();
  }

}
