/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.gcsio.StatisticTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
public enum GhfsStatistic {
    ACTION_HTTP_GET_REQUEST("action_http_get_request", "GET request.", StatisticTypeEnum.TYPE_COUNTER),
    ACTION_HTTP_PUT_REQUEST("action_http_put_request", "PUT request.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_HTTP_PATCH_REQUEST("action_http_patch_request", "PATCH request.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_HTTP_DELETE_REQUEST("action_http_delete_request", "DELETE request.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_HTTP_POST_REQUEST("action_http_post_request", "POST request.", StatisticTypeEnum.TYPE_DURATION),
    DIRECTORIES_CREATED("directories_created", "Total number of directories created through the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_CREATED("files_created", "Total number of files created through the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_DELETED("files_deleted", "Total number of files deleted from the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_DELETE_REJECTED("files_delete_rejected", "Total number of files whose delete request was rejected", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_CREATE("op_create", "Calls of create()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_DELETE("op_delete", "Calls of delete()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_EXISTS("op_exists", "Calls of exists()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_GET_FILE_STATUS("op_get_file_status", "Calls of getFileStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_FILE_CHECKSUM("op_get_file_checksum", "Calls of getFileChecksum()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_LIST_STATUS_RESULT_SIZE("op_get_list_status_result_size", "Number of files returned from list call", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_GLOB_STATUS("op_glob_status", "Calls of globStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_HFLUSH("op_hflush", "Calls of hflush()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_HSYNC("op_hsync", "Calls of hsync()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_LIST_STATUS("op_list_status", "Calls of listStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_MKDIRS("op_mkdirs", "Calls of mkdirs()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_OPEN("op_open", "Calls of open()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_RENAME("op_rename", "Calls of rename()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_COPY_FROM_LOCAL_FILE("op_copy_from_local_file", "Calls of copyFromLocalFile()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_CREATE_NON_RECURSIVE("op_create_non_recursive", "Calls of createNonRecursive()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_DELEGATION_TOKEN("op_get_delegation_token", "Calls of getDelegationToken()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_LIST_LOCATED_STATUS("op_list_located_status", "Calls of listLocatedStatus()", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_BYTES("stream_read_bytes", "Bytes read from an input stream in read() calls", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_CLOSE_OPERATIONS("stream_read_close_operations", "Calls of read stream close()", StatisticTypeEnum.TYPE_DURATION),
    STREAM_READ_VECTORED_OPERATIONS("stream_read_vectored_operations", "Calls of readVectored()", StatisticTypeEnum.TYPE_DURATION),
    STREAM_READ_VECTORED_EXTRA_READ_BYTES("stream_read_vectored_read_bytes_discarded", "Discarded read bytes during readVectored operation", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VECTORED_READ_RANGE_DURATION("stream_readVectored_range_duration", "Latency of individual FileRange", StatisticTypeEnum.TYPE_DURATION),
    STREAM_READ_VECTORED_READ_INCOMING_RANGES("stream_read_vectored_incoming_ranges", "size of fileRanges requested in readVectoredRequest", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_OPERATIONS("stream_read_operations", "Calls of read()", StatisticTypeEnum.TYPE_DURATION_TOTAL),
    STREAM_READ_VECTORED_READ_COMBINED_RANGES("stream_read_vectored_combined_ranges", "size of combined fileRange requested per readVectoredRequest", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_OPERATIONS_INCOMPLETE("stream_read_operations_incomplete", "Count of incomplete read() operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BACKWARD_OPERATIONS("stream_read_seek_backward_operations", "Count of executed seek operations which went backwards in a stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BYTES_BACKWARDS("stream_read_bytes_backwards_on_seek", "Count of bytes moved backwards during seek operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BYTES_SKIPPED("stream_read_seek_bytes_skipped", "Count of bytes skipped during forward seek operations an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_FORWARD_OPERATIONS("stream_read_seek_forward_operations", "Count of executed seek operations which went forward in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_OPERATIONS("stream_read_seek_operations", "Calls of seek()", StatisticTypeEnum.TYPE_DURATION),
    STREAM_WRITE_BYTES("stream_write_bytes", "Count of bytes written to output stream (including all not yet uploaded)", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_CLOSE_OPERATIONS("stream_write_close_operations", "Calls of write stream close()", StatisticTypeEnum.TYPE_DURATION),
    STREAM_WRITE_OPERATIONS("stream_write_operations", "Calls of write()", StatisticTypeEnum.TYPE_DURATION_TOTAL),
    INVOCATION_XATTR_GET_MAP("op_xattr_get_map", "Calls of getXAttrs(Path path)", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_XATTR_GET_NAMED("op_xattr_get_named", "Calls of getXAttr(Path, String)", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_XATTR_GET_NAMED_MAP("op_xattr_get_named_map", "Calls of xattr()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_OP_XATTR_LIST("op_xattr_list", "Calls of getXAttrs(Path path, List<String> names)", StatisticTypeEnum.TYPE_DURATION),
    DELEGATION_TOKENS_ISSUED("delegation_tokens_issued", "Count of delegation tokens issued", StatisticTypeEnum.TYPE_DURATION),
    GCS_CONNECTOR_TIME("gcs_connector_time", "Time in milliseconds spend on HDFS API calls. Note that sometimes this might be less than GCS_API_TIME since some of the operations are done concurrently", StatisticTypeEnum.TYPE_COUNTER);

    public static final ImmutableSet<GhfsStatistic> VALUES;
    private static final ImmutableMap<String, GhfsStatistic> SYMBOL_MAP;
    private final String symbol;
    private final String description;
    private final StatisticTypeEnum type;

    private GhfsStatistic(String symbol, String description, StatisticTypeEnum type) {
        this.symbol = symbol;
        this.description = description;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static GhfsStatistic fromSymbol(String symbol) {
        return (GhfsStatistic)((Object)SYMBOL_MAP.get((Object)symbol));
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    public StatisticTypeEnum getType() {
        return this.type;
    }

    static {
        VALUES = ImmutableSet.copyOf(EnumSet.allOf(GhfsStatistic.class));
        SYMBOL_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])GhfsStatistic.values()), GhfsStatistic::getSymbol);
    }
}

