/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.NanoClock;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.ExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.AutoValue_ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.EndpointContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Watchdog;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.WatchdogProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.internal.QuotaProjectIdHidingCredentials;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.BaseApiTracerFactory;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GdchCredentials;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.Sets;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class ClientContext {
    private static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";

    public abstract List<BackgroundResource> getBackgroundResources();

    public abstract ScheduledExecutorService getExecutor();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TransportChannel getTransportChannel();

    public abstract Map<String, String> getHeaders();

    protected abstract Map<String, String> getInternalHeaders();

    public abstract ApiClock getClock();

    public abstract ApiCallContext getDefaultCallContext();

    @Nullable
    public abstract Watchdog getStreamWatchdog();

    @Nonnull
    public abstract Duration getStreamWatchdogCheckInterval();

    @Nullable
    abstract String getServiceName();

    @Nullable
    public abstract String getUniverseDomain();

    @Nullable
    public abstract String getEndpoint();

    @Nullable
    public abstract String getQuotaProjectId();

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
    @Nonnull
    public abstract ApiTracerFactory getTracerFactory();

    @Nullable
    public abstract String getGdchApiAudience();

    public static Builder newBuilder() {
        return new AutoValue_ClientContext.Builder().setBackgroundResources(Collections.emptyList()).setExecutor(Executors.newScheduledThreadPool(0)).setHeaders(Collections.emptyMap()).setInternalHeaders(Collections.emptyMap()).setClock(NanoClock.getDefaultClock()).setStreamWatchdog(null).setStreamWatchdogCheckInterval(Duration.ZERO).setTracerFactory(BaseApiTracerFactory.getInstance()).setQuotaProjectId(null).setGdchApiAudience(null);
    }

    public abstract Builder toBuilder();

    public static ClientContext create(ClientSettings settings) throws IOException {
        return ClientContext.create(settings.getStubSettings());
    }

    public static ClientContext create(StubSettings settings) throws IOException {
        TransportChannelProvider transportChannelProvider;
        ApiClock clock = settings.getClock();
        ExecutorProvider backgroundExecutorProvider = settings.getBackgroundExecutorProvider();
        ScheduledExecutorService backgroundExecutor = backgroundExecutorProvider.getExecutor();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        boolean usingGDCH = credentials instanceof GdchCredentials;
        EndpointContext endpointContext = EndpointContext.newBuilder().setServiceName(settings.getServiceName()).setUniverseDomain(settings.getUniverseDomain()).setClientSettingsEndpoint(settings.getUserSetEndpoint()).setTransportChannelProviderEndpoint(settings.getTransportChannelProvider().getEndpoint()).setMtlsEndpoint(settings.getMtlsEndpoint()).setSwitchToMtlsEndpointAllowed(settings.getSwitchToMtlsEndpointAllowed()).setUsingGDCH(usingGDCH).build();
        String endpoint = endpointContext.resolvedEndpoint();
        String settingsGdchApiAudience = settings.getGdchApiAudience();
        if (usingGDCH) {
            URI gdchAudienceUri;
            String audienceString;
            if (!Strings.isNullOrEmpty(settingsGdchApiAudience)) {
                audienceString = settingsGdchApiAudience;
            } else if (!Strings.isNullOrEmpty(endpoint)) {
                audienceString = endpoint;
            } else {
                throw new IllegalArgumentException("Could not infer GDCH api audience from settings");
            }
            try {
                gdchAudienceUri = URI.create(audienceString);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("The GDC-H API audience string is not a valid URI", ex);
            }
            credentials = ((GdchCredentials)credentials).createWithGdchAudience(gdchAudienceUri);
        } else if (!Strings.isNullOrEmpty(settingsGdchApiAudience)) {
            throw new IllegalArgumentException("GDC-H API audience can only be set when using GdchCredentials");
        }
        if (settings.getQuotaProjectId() != null && credentials != null) {
            credentials = new QuotaProjectIdHidingCredentials(credentials);
        }
        if ((transportChannelProvider = settings.getTransportChannelProvider()).needsExecutor() && settings.getExecutorProvider() != null) {
            transportChannelProvider = transportChannelProvider.withExecutor(backgroundExecutor);
        }
        Map<String, String> headers = ClientContext.getHeadersFromSettings(settings);
        if (transportChannelProvider.needsHeaders()) {
            transportChannelProvider = transportChannelProvider.withHeaders(headers);
        }
        if (transportChannelProvider.needsCredentials() && credentials != null) {
            transportChannelProvider = transportChannelProvider.withCredentials(credentials);
        }
        if (transportChannelProvider.needsEndpoint()) {
            transportChannelProvider = transportChannelProvider.withEndpoint(endpoint);
        }
        TransportChannel transportChannel = transportChannelProvider.getTransportChannel();
        ApiCallContext defaultCallContext = transportChannel.getEmptyCallContext().withTransportChannel(transportChannel);
        if (credentials != null) {
            defaultCallContext = defaultCallContext.withCredentials(credentials);
        }
        defaultCallContext = defaultCallContext.withEndpointContext(endpointContext);
        WatchdogProvider watchdogProvider = settings.getStreamWatchdogProvider();
        Watchdog watchdog = null;
        if (watchdogProvider != null) {
            if (watchdogProvider.needsCheckInterval()) {
                watchdogProvider = watchdogProvider.withCheckInterval(settings.getStreamWatchdogCheckInterval());
            }
            if (watchdogProvider.needsClock()) {
                watchdogProvider = watchdogProvider.withClock(clock);
            }
            if (watchdogProvider.needsExecutor()) {
                watchdogProvider = watchdogProvider.withExecutor(backgroundExecutor);
            }
            watchdog = watchdogProvider.getWatchdog();
        }
        ImmutableList.Builder backgroundResources = ImmutableList.builder();
        if (transportChannelProvider.shouldAutoClose()) {
            backgroundResources.add(transportChannel);
        }
        if (backgroundExecutorProvider.shouldAutoClose()) {
            backgroundResources.add(new ExecutorAsBackgroundResource(backgroundExecutor));
        }
        if (watchdogProvider != null && watchdogProvider.shouldAutoClose()) {
            backgroundResources.add(watchdog);
        }
        return ClientContext.newBuilder().setBackgroundResources((List<BackgroundResource>)((Object)backgroundResources.build())).setExecutor(backgroundExecutor).setCredentials(credentials).setTransportChannel(transportChannel).setHeaders(ImmutableMap.copyOf(settings.getHeaderProvider().getHeaders())).setInternalHeaders(ImmutableMap.copyOf(settings.getInternalHeaderProvider().getHeaders())).setClock(clock).setDefaultCallContext(defaultCallContext).setServiceName(settings.getServiceName()).setUniverseDomain(settings.getUniverseDomain()).setEndpoint(settings.getEndpoint()).setQuotaProjectId(settings.getQuotaProjectId()).setStreamWatchdog(watchdog).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval()).setTracerFactory(settings.getTracerFactory()).build();
    }

    private static Map<String, String> getHeadersFromSettings(StubSettings settings) {
        Map<String, String> userHeaders = settings.getHeaderProvider().getHeaders();
        Map<String, String> internalHeaders = settings.getInternalHeaderProvider().getHeaders();
        HashMap<String, String> conflictResolution = new HashMap<String, String>();
        Sets.SetView<String> conflicts = Sets.intersection(userHeaders.keySet(), internalHeaders.keySet());
        for (String key : conflicts) {
            if ("user-agent".equals(key)) {
                conflictResolution.put(key, userHeaders.get(key) + " " + internalHeaders.get(key));
                continue;
            }
            if (QUOTA_PROJECT_ID_HEADER_KEY.equals(key) && settings.getQuotaProjectId() != null) continue;
            throw new IllegalArgumentException("Header provider can't override the header: " + key);
        }
        if (settings.getQuotaProjectId() != null) {
            conflictResolution.put(QUOTA_PROJECT_ID_HEADER_KEY, settings.getQuotaProjectId());
        }
        HashMap<String, String> effectiveHeaders = new HashMap<String, String>();
        effectiveHeaders.putAll(internalHeaders);
        effectiveHeaders.putAll(userHeaders);
        effectiveHeaders.putAll(conflictResolution);
        return ImmutableMap.copyOf(effectiveHeaders);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackgroundResources(List<BackgroundResource> var1);

        public abstract Builder setExecutor(ScheduledExecutorService var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTransportChannel(TransportChannel var1);

        public abstract Builder setHeaders(Map<String, String> var1);

        protected abstract Builder setInternalHeaders(Map<String, String> var1);

        public abstract Builder setClock(ApiClock var1);

        public abstract Builder setDefaultCallContext(ApiCallContext var1);

        abstract Builder setServiceName(String var1);

        public abstract Builder setUniverseDomain(String var1);

        public abstract Builder setEndpoint(String var1);

        public abstract Builder setQuotaProjectId(String var1);

        public abstract Builder setStreamWatchdog(Watchdog var1);

        public abstract Builder setStreamWatchdogCheckInterval(Duration var1);

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        public abstract Builder setTracerFactory(ApiTracerFactory var1);

        public abstract Builder setGdchApiAudience(String var1);

        public abstract ClientContext build();
    }
}

