/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.contrib.http;

import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.contrib.http.HttpExtractor;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.contrib.http.HttpRequestContext;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.contrib.http.util.HttpTraceUtil;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.MessageEvent;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

abstract class AbstractHttpHandler<Q, P> {
    @VisibleForTesting
    final HttpExtractor<Q, P> extractor;

    AbstractHttpHandler(HttpExtractor<Q, P> extractor) {
        Preconditions.checkNotNull(extractor, "extractor");
        this.extractor = extractor;
    }

    static void recordMessageEvent(Span span, long id, MessageEvent.Type type, long uncompressedMessageSize, long compressedMessageSize) {
        MessageEvent messageEvent = MessageEvent.builder(type, id).setUncompressedMessageSize(uncompressedMessageSize).setCompressedMessageSize(compressedMessageSize).build();
        span.addMessageEvent(messageEvent);
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, @Nullable String value) {
        if (value != null && !value.isEmpty()) {
            span.putAttribute(key, AttributeValue.stringAttributeValue(value));
        }
    }

    public final void handleMessageSent(HttpRequestContext context, long bytes) {
        Preconditions.checkNotNull(context, "context");
        context.sentMessageSize.addAndGet(bytes);
        if (context.span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(context.span, context.sentSeqId.addAndGet(1L), MessageEvent.Type.SENT, bytes, 0L);
        }
    }

    public final void handleMessageReceived(HttpRequestContext context, long bytes) {
        Preconditions.checkNotNull(context, "context");
        context.receiveMessageSize.addAndGet(bytes);
        if (context.span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(context.span, context.receviedSeqId.addAndGet(1L), MessageEvent.Type.RECEIVED, bytes, 0L);
        }
    }

    void spanEnd(Span span, int httpStatus, @Nullable Throwable error) {
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            span.putAttribute("http.status_code", AttributeValue.longAttributeValue(httpStatus));
            span.setStatus(HttpTraceUtil.parseResponseStatus(httpStatus, error));
        }
        span.end();
    }

    final String getSpanName(Q request, HttpExtractor<Q, P> extractor) {
        String path = extractor.getPath(request);
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    final void addSpanRequestAttributes(Span span, Q request, HttpExtractor<Q, P> extractor) {
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.user_agent", extractor.getUserAgent(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.host", extractor.getHost(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.method", extractor.getMethod(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.path", extractor.getPath(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.route", extractor.getRoute(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.url", extractor.getUrl(request));
    }

    public Span getSpanFromContext(HttpRequestContext context) {
        Preconditions.checkNotNull(context, "context");
        return context.span;
    }

    HttpRequestContext getNewContext(Span span, TagContext tagContext) {
        return new HttpRequestContext(span, tagContext);
    }
}

