/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Type;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import javax.annotation.Nonnull;

public final class CreateTableRequest {
    private final CreateTableRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest.newBuilder();

    public static CreateTableRequest of(String tableId) {
        return new CreateTableRequest(tableId);
    }

    private CreateTableRequest(String tableId) {
        this.requestBuilder.setTableId(tableId);
    }

    public CreateTableRequest addFamily(String familyId) {
        Preconditions.checkNotNull(familyId);
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, ColumnFamily.getDefaultInstance());
        return this;
    }

    public CreateTableRequest addFamily(@Nonnull String familyId, @Nonnull GCRules.GCRule gcRule) {
        return this.addFamily(familyId, gcRule, Type.raw());
    }

    public CreateTableRequest addFamily(@Nonnull String familyId, @Nonnull Type valueType) {
        return this.addFamily(familyId, GCRules.GCRULES.defaultRule(), valueType);
    }

    public CreateTableRequest addFamily(@Nonnull String familyId, @Nonnull GCRules.GCRule gcRule, @Nonnull Type valueType) {
        Preconditions.checkNotNull(familyId);
        Preconditions.checkNotNull(gcRule);
        Preconditions.checkNotNull(valueType);
        ColumnFamily.Builder builder = ColumnFamily.newBuilder().setGcRule(gcRule.toProto());
        if (!valueType.equals(Type.raw())) {
            builder.setValueType(valueType.toProto());
        }
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, builder.build());
        return this;
    }

    public CreateTableRequest addSplit(ByteString key) {
        Preconditions.checkNotNull(key);
        this.requestBuilder.addInitialSplitsBuilder().setKey(key);
        return this;
    }

    public CreateTableRequest addChangeStreamRetention(com.google.bigtable.repackaged.org.threeten.bp.Duration retention) {
        Preconditions.checkNotNull(retention);
        this.requestBuilder.getTableBuilder().setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableRequest that = (CreateTableRequest)o;
        return Objects.equal(this.requestBuilder.build(), that.requestBuilder.build());
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.build());
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).build();
    }
}

