/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.AddToCell;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.AutoValue_ChangeStreamMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DeleteCells;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DeleteFamily;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Entry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.SetCell;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Value;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import java.io.Serializable;
import javax.annotation.Nonnull;

@InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
@AutoValue
public abstract class ChangeStreamMutation
implements ChangeStreamRecord,
Serializable {
    private static final long serialVersionUID = 8419520253162024218L;

    static Builder createUserMutation(@Nonnull ByteString rowKey, @Nonnull String sourceClusterId, Instant commitTimestamp, int tieBreaker) {
        return ChangeStreamMutation.builder().setRowKey(rowKey).setType(MutationType.USER).setSourceClusterId(sourceClusterId).setCommitTimestamp(commitTimestamp).setTieBreaker(tieBreaker);
    }

    static Builder createGcMutation(@Nonnull ByteString rowKey, Instant commitTimestamp, int tieBreaker) {
        return ChangeStreamMutation.builder().setRowKey(rowKey).setType(MutationType.GARBAGE_COLLECTION).setSourceClusterId("").setCommitTimestamp(commitTimestamp).setTieBreaker(tieBreaker);
    }

    @Nonnull
    public abstract ByteString getRowKey();

    @Nonnull
    public abstract MutationType getType();

    @Nonnull
    public abstract String getSourceClusterId();

    public abstract Instant getCommitTimestamp();

    public abstract int getTieBreaker();

    @Nonnull
    public abstract String getToken();

    public abstract Instant getEstimatedLowWatermark();

    @Nonnull
    public abstract ImmutableList<Entry> getEntries();

    static Builder builder() {
        return new AutoValue_ChangeStreamMutation.Builder();
    }

    public RowMutation toRowMutation(@Nonnull String tableId) {
        RowMutation rowMutation = RowMutation.create(tableId, this.getRowKey());
        for (Entry entry : this.getEntries()) {
            if (entry instanceof DeleteFamily) {
                rowMutation.deleteFamily(((DeleteFamily)entry).getFamilyName());
                continue;
            }
            if (entry instanceof DeleteCells) {
                DeleteCells deleteCells = (DeleteCells)entry;
                rowMutation.deleteCells(deleteCells.getFamilyName(), deleteCells.getQualifier(), deleteCells.getTimestampRange());
                continue;
            }
            if (entry instanceof SetCell) {
                SetCell setCell = (SetCell)entry;
                rowMutation.setCell(setCell.getFamilyName(), setCell.getQualifier(), setCell.getTimestamp(), setCell.getValue());
                continue;
            }
            if (entry instanceof AddToCell) {
                AddToCell addToCell = (AddToCell)entry;
                rowMutation.addToCell(addToCell.getFamily(), addToCell.getQualifier(), addToCell.getTimestamp(), addToCell.getInput());
                continue;
            }
            throw new IllegalArgumentException("Unexpected Entry type.");
        }
        return rowMutation;
    }

    public RowMutationEntry toRowMutationEntry() {
        RowMutationEntry rowMutationEntry = RowMutationEntry.create(this.getRowKey());
        for (Entry entry : this.getEntries()) {
            if (entry instanceof DeleteFamily) {
                rowMutationEntry.deleteFamily(((DeleteFamily)entry).getFamilyName());
                continue;
            }
            if (entry instanceof DeleteCells) {
                DeleteCells deleteCells = (DeleteCells)entry;
                rowMutationEntry.deleteCells(deleteCells.getFamilyName(), deleteCells.getQualifier(), deleteCells.getTimestampRange());
                continue;
            }
            if (entry instanceof SetCell) {
                SetCell setCell = (SetCell)entry;
                rowMutationEntry.setCell(setCell.getFamilyName(), setCell.getQualifier(), setCell.getTimestamp(), setCell.getValue());
                continue;
            }
            if (entry instanceof AddToCell) {
                AddToCell addToCell = (AddToCell)entry;
                rowMutationEntry.addToCell(addToCell.getFamily(), addToCell.getQualifier(), addToCell.getTimestamp(), addToCell.getInput());
                continue;
            }
            throw new IllegalArgumentException("Unexpected Entry type.");
        }
        return rowMutationEntry;
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setRowKey(@Nonnull ByteString var1);

        abstract Builder setType(@Nonnull MutationType var1);

        abstract Builder setSourceClusterId(@Nonnull String var1);

        abstract Builder setCommitTimestamp(Instant var1);

        abstract Builder setTieBreaker(int var1);

        abstract ImmutableList.Builder<Entry> entriesBuilder();

        abstract Builder setToken(@Nonnull String var1);

        abstract Builder setEstimatedLowWatermark(Instant var1);

        Builder setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
            this.entriesBuilder().add((Object)SetCell.create(familyName, qualifier, timestamp, value));
            return this;
        }

        Builder deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
            this.entriesBuilder().add((Object)DeleteCells.create(familyName, qualifier, timestampRange));
            return this;
        }

        Builder deleteFamily(@Nonnull String familyName) {
            this.entriesBuilder().add((Object)DeleteFamily.create(familyName));
            return this;
        }

        Builder addToCell(@Nonnull String familyName, Value qualifier, Value timestamp, Value input) {
            this.entriesBuilder().add((Object)AddToCell.create(familyName, qualifier, timestamp, input));
            return this;
        }

        abstract ChangeStreamMutation build();
    }

    public static enum MutationType {
        USER,
        GARBAGE_COLLECTION;

    }
}

