/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CookiesHolder;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.logging.Level;
import java.util.logging.Logger;

class CookiesInterceptor
implements ClientInterceptor {
    private static final Logger LOG = Logger.getLogger(CookiesInterceptor.class.getName());

    CookiesInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, final CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                try {
                    CookiesHolder cookie = CookiesHolder.fromCallOptions(callOptions);
                    if (cookie != null) {
                        headers = cookie.injectCookiesInRequestHeaders(headers);
                        responseListener = new UpdateCookieListener(responseListener, cookie);
                    }
                }
                catch (Throwable e) {
                    LOG.warning("Failed to inject cookie to request headers: " + e);
                }
                finally {
                    super.start(responseListener, headers);
                }
            }
        };
    }

    static class UpdateCookieListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final CookiesHolder cookie;

        UpdateCookieListener(ClientCall.Listener<RespT> delegate, CookiesHolder cookiesHolder) {
            super(delegate);
            this.cookie = cookiesHolder;
        }

        @Override
        public void onHeaders(Metadata headers) {
            try {
                this.cookie.extractCookiesFromMetadata(headers);
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Failed to extract cookie from response headers.", e);
            }
            finally {
                super.onHeaders(headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(Status status, Metadata trailers) {
            try {
                this.cookie.extractCookiesFromMetadata(trailers);
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Failed to extract cookie from response trailers.", e);
            }
            finally {
                super.onClose(status, trailers);
            }
        }
    }
}

