/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;

public class GenerateInitialChangeStreamPartitionsUserCallable
extends ServerStreamingCallable<String, Range.ByteStringRange> {
    private final RequestContext requestContext;
    private final ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> inner;

    public GenerateInitialChangeStreamPartitionsUserCallable(ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> inner, RequestContext requestContext) {
        this.requestContext = requestContext;
        this.inner = inner;
    }

    @Override
    public void call(String tableId, ResponseObserver<Range.ByteStringRange> responseObserver, ApiCallContext context) {
        String tableName = NameUtil.formatTableName(this.requestContext.getProjectId(), this.requestContext.getInstanceId(), tableId);
        GenerateInitialChangeStreamPartitionsRequest request = GenerateInitialChangeStreamPartitionsRequest.newBuilder().setTableName(tableName).setAppProfileId(this.requestContext.getAppProfileId()).build();
        this.inner.call(request, new ConvertPartitionToRangeObserver(responseObserver), context);
    }

    private static class ConvertPartitionToRangeObserver
    implements ResponseObserver<GenerateInitialChangeStreamPartitionsResponse> {
        private final ResponseObserver<Range.ByteStringRange> outerObserver;

        ConvertPartitionToRangeObserver(ResponseObserver<Range.ByteStringRange> observer) {
            this.outerObserver = observer;
        }

        @Override
        public void onStart(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        @Override
        public void onResponse(GenerateInitialChangeStreamPartitionsResponse response) {
            Range.ByteStringRange byteStringRange = Range.ByteStringRange.create(response.getPartition().getRowRange().getStartKeyClosed(), response.getPartition().getRowRange().getEndKeyOpen());
            this.outerObserver.onResponse(byteStringRange);
        }

        @Override
        public void onError(Throwable t) {
            this.outerObserver.onError(t);
        }

        @Override
        public void onComplete() {
            this.outerObserver.onComplete();
        }
    }
}

