/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import java.util.concurrent.TimeUnit;

class BigtableGrpcStreamTracer
extends ClientStreamTracer {
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final BigtableTracer tracer;

    public BigtableGrpcStreamTracer(BigtableTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public void streamCreated(Attributes transportAttrs, Metadata headers) {
        this.stopwatch.start();
    }

    @Override
    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        this.tracer.grpcChannelQueuedLatencies(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    static class Factory
    extends ClientStreamTracer.Factory {
        private final BigtableTracer tracer;

        Factory(BigtableTracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new BigtableGrpcStreamTracer(this.tracer);
        }
    }
}

