/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingContext;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.protobuf.util.Durations;
import com.google.bigtable.repackaged.com.google.rpc.RetryInfo;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
public class RetryInfoRetryAlgorithm<ResponseT>
extends BasicResultRetryAlgorithm<ResponseT> {
    @Override
    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        Duration retryDelay = RetryInfoRetryAlgorithm.extractRetryDelay(prevThrowable);
        if (retryDelay != null) {
            return prevSettings.toBuilder().setRandomizedRetryDelay(retryDelay).setAttemptCount(prevSettings.getAttemptCount() + 1).setOverallAttemptCount(prevSettings.getAttemptCount() + 1).build();
        }
        return null;
    }

    @Override
    public boolean shouldRetry(Throwable previousThrowable, ResponseT previousResponse) {
        return this.shouldRetry(null, previousThrowable, previousResponse);
    }

    @Override
    public boolean shouldRetry(@Nullable RetryingContext context, Throwable previousThrowable, ResponseT previousResponse) {
        if (RetryInfoRetryAlgorithm.extractRetryDelay(previousThrowable) != null) {
            return true;
        }
        if (context != null && context.getRetryableCodes() != null) {
            return previousThrowable instanceof ApiException && context.getRetryableCodes().contains((Object)((ApiException)previousThrowable).getStatusCode().getCode());
        }
        return previousThrowable instanceof ApiException && ((ApiException)previousThrowable).isRetryable();
    }

    static @Nullable Duration extractRetryDelay(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (!(throwable instanceof ApiException)) {
            return null;
        }
        ApiException exception = (ApiException)throwable;
        if (exception.getErrorDetails() == null) {
            return null;
        }
        if (exception.getErrorDetails().getRetryInfo() == null) {
            return null;
        }
        RetryInfo retryInfo = exception.getErrorDetails().getRetryInfo();
        return Duration.ofMillis(Durations.toMillis(retryInfo.getRetryDelay()));
    }
}

