/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.trace.v1;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPage;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.TraceServiceSettings;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.TraceServiceStubSettings;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.Trace;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.Traces;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TraceServiceClient
implements BackgroundResource {
    private final TraceServiceSettings settings;
    private final TraceServiceStub stub;

    public static final TraceServiceClient create() throws IOException {
        return TraceServiceClient.create(TraceServiceSettings.newBuilder().build());
    }

    public static final TraceServiceClient create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceClient(settings);
    }

    public static final TraceServiceClient create(TraceServiceStub stub) {
        return new TraceServiceClient(stub);
    }

    protected TraceServiceClient(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TraceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected TraceServiceClient(TraceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    public TraceServiceStub getStub() {
        return this.stub;
    }

    public final ListTracesPagedResponse listTraces(String projectId) {
        ListTracesRequest request = ListTracesRequest.newBuilder().setProjectId(projectId).build();
        return this.listTraces(request);
    }

    public final ListTracesPagedResponse listTraces(ListTracesRequest request) {
        return this.listTracesPagedCallable().call(request);
    }

    public final UnaryCallable<ListTracesRequest, ListTracesPagedResponse> listTracesPagedCallable() {
        return this.stub.listTracesPagedCallable();
    }

    public final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.stub.listTracesCallable();
    }

    public final Trace getTrace(String projectId, String traceId) {
        GetTraceRequest request = GetTraceRequest.newBuilder().setProjectId(projectId).setTraceId(traceId).build();
        return this.getTrace(request);
    }

    public final Trace getTrace(GetTraceRequest request) {
        return this.getTraceCallable().call(request);
    }

    public final UnaryCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.stub.getTraceCallable();
    }

    public final void patchTraces(String projectId, Traces traces) {
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(projectId).setTraces(traces).build();
        this.patchTraces(request);
    }

    public final void patchTraces(PatchTracesRequest request) {
        this.patchTracesCallable().call(request);
    }

    public final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.stub.patchTracesCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTracesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage, ListTracesFixedSizeCollection> {
        private ListTracesFixedSizeCollection(List<ListTracesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTracesFixedSizeCollection createEmptyCollection() {
            return new ListTracesFixedSizeCollection(null, 0);
        }

        @Override
        protected ListTracesFixedSizeCollection createCollection(List<ListTracesPage> pages, int collectionSize) {
            return new ListTracesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTracesPage
    extends AbstractPage<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage> {
        private ListTracesPage(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ListTracesResponse response) {
            super(context, response);
        }

        private static ListTracesPage createEmptyPage() {
            return new ListTracesPage(null, null);
        }

        @Override
        protected ListTracesPage createPage(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ListTracesResponse response) {
            return new ListTracesPage(context, response);
        }

        @Override
        public ApiFuture<ListTracesPage> createPageAsync(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ApiFuture<ListTracesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTracesPagedResponse
    extends AbstractPagedListResponse<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage, ListTracesFixedSizeCollection> {
        public static ApiFuture<ListTracesPagedResponse> createAsync(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ApiFuture<ListTracesResponse> futureResponse) {
            ApiFuture<ListTracesPage> futurePage = ListTracesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTracesPagedResponse((ListTracesPage)input), MoreExecutors.directExecutor());
        }

        private ListTracesPagedResponse(ListTracesPage page) {
            super(page, ListTracesFixedSizeCollection.createEmptyCollection());
        }
    }
}

