/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusException;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.grpc.xds.SharedXdsClientPoolProvider;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsNameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.xds.XdsResourceType;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ClientResourceStatus;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.UpdateFailureState;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientConfig;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusDiscoveryServiceGrpc;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusRequest;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusResponse;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8016")
public final class CsdsService
extends ClientStatusDiscoveryServiceGrpc.ClientStatusDiscoveryServiceImplBase {
    private static final Logger logger = Logger.getLogger(CsdsService.class.getName());
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;

    @VisibleForTesting
    CsdsService(XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = Preconditions.checkNotNull(xdsClientPoolFactory, "xdsClientPoolProvider");
    }

    private CsdsService() {
        this(SharedXdsClientPoolProvider.getDefaultProvider());
    }

    public static CsdsService newInstance() {
        return new CsdsService();
    }

    @Override
    public void fetchClientStatus(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        if (this.handleRequest(request, responseObserver)) {
            responseObserver.onCompleted();
        }
    }

    @Override
    public StreamObserver<ClientStatusRequest> streamClientStatus(final StreamObserver<ClientStatusResponse> responseObserver) {
        return new StreamObserver<ClientStatusRequest>(){

            @Override
            public void onNext(ClientStatusRequest request) {
                CsdsService.this.handleRequest(request, responseObserver);
            }

            @Override
            public void onError(Throwable t) {
                this.onCompleted();
            }

            @Override
            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private boolean handleRequest(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        StatusException error;
        try {
            responseObserver.onNext(this.getConfigDumpForRequest(request));
            return true;
        }
        catch (StatusException e) {
            error = e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.log(Level.FINE, "Server interrupted while building CSDS config dump", e);
            error = Status.ABORTED.withDescription("Thread interrupted").withCause(e).asException();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Unexpected error while building CSDS config dump", e);
            error = Status.INTERNAL.withDescription("Unexpected internal error").withCause(e).asException();
        }
        responseObserver.onError(error);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientStatusResponse getConfigDumpForRequest(ClientStatusRequest request) throws StatusException, InterruptedException {
        if (request.getNodeMatchersCount() > 0) {
            throw new StatusException(Status.INVALID_ARGUMENT.withDescription("node_matchers not supported"));
        }
        ObjectPool<XdsClient> xdsClientPool = this.xdsClientPoolFactory.get();
        if (xdsClientPool == null) {
            return ClientStatusResponse.getDefaultInstance();
        }
        XdsClient xdsClient = null;
        try {
            xdsClient = xdsClientPool.getObject();
            ClientStatusResponse clientStatusResponse = ClientStatusResponse.newBuilder().addConfig(CsdsService.getClientConfigForXdsClient(xdsClient)).build();
            return clientStatusResponse;
        }
        finally {
            if (xdsClient != null) {
                xdsClientPool.returnObject(xdsClient);
            }
        }
    }

    @VisibleForTesting
    static ClientConfig getClientConfigForXdsClient(XdsClient xdsClient) throws InterruptedException {
        ClientConfig.Builder builder = ClientConfig.newBuilder().setNode(xdsClient.getBootstrapInfo().node().toEnvoyProtoNode());
        Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByType = CsdsService.awaitSubscribedResourcesMetadata(xdsClient.getSubscribedResourcesMetadataSnapshot());
        for (Map.Entry<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByTypeEntry : metadataByType.entrySet()) {
            XdsResourceType<?> type = metadataByTypeEntry.getKey();
            Map<String, XdsClient.ResourceMetadata> metadataByResourceName = metadataByTypeEntry.getValue();
            for (Map.Entry<String, XdsClient.ResourceMetadata> metadataEntry : metadataByResourceName.entrySet()) {
                String resourceName = metadataEntry.getKey();
                XdsClient.ResourceMetadata metadata = metadataEntry.getValue();
                ClientConfig.GenericXdsConfig.Builder genericXdsConfigBuilder = ClientConfig.GenericXdsConfig.newBuilder().setTypeUrl(type.typeUrl()).setName(resourceName).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus()));
                if (metadata.getRawResource() != null) {
                    genericXdsConfigBuilder.setVersionInfo(metadata.getVersion()).setLastUpdated(Timestamps.fromNanos(metadata.getUpdateTimeNanos())).setXdsConfig(metadata.getRawResource());
                }
                if (metadata.getStatus() == XdsClient.ResourceMetadata.ResourceMetadataStatus.NACKED) {
                    Verify.verifyNotNull(metadata.getErrorState(), "resource %s getErrorState", resourceName);
                    genericXdsConfigBuilder.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
                }
                builder.addGenericXdsConfigs(genericXdsConfigBuilder);
            }
        }
        return builder.build();
    }

    private static Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> awaitSubscribedResourcesMetadata(ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> future) throws InterruptedException {
        try {
            return (Map)future.get(20L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static ClientResourceStatus metadataStatusToClientStatus(XdsClient.ResourceMetadata.ResourceMetadataStatus status) {
        switch (status) {
            case UNKNOWN: {
                return ClientResourceStatus.UNKNOWN;
            }
            case DOES_NOT_EXIST: {
                return ClientResourceStatus.DOES_NOT_EXIST;
            }
            case REQUESTED: {
                return ClientResourceStatus.REQUESTED;
            }
            case ACKED: {
                return ClientResourceStatus.ACKED;
            }
            case NACKED: {
                return ClientResourceStatus.NACKED;
            }
        }
        throw new AssertionError((Object)("Unexpected ResourceMetadataStatus: " + (Object)((Object)status)));
    }

    private static UpdateFailureState metadataUpdateFailureStateToProto(XdsClient.ResourceMetadata.UpdateFailureState errorState) {
        return UpdateFailureState.newBuilder().setLastUpdateAttempt(Timestamps.fromNanos(errorState.getFailedUpdateTimeNanos())).setDetails(errorState.getFailedDetails()).setVersionInfo(errorState.getFailedVersion()).build();
    }
}

