/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.FilterRegistry;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10847")
public abstract class XdsResourceType<T extends XdsClient.ResourceUpdate> {
    static final String TYPE_URL_RESOURCE = "type.googleapis.com/envoy.service.discovery.v3.Resource";
    static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    @VisibleForTesting
    static final String HASH_POLICY_FILTER_STATE_KEY = "com.google.bigtable.repackaged.io.grpc.channel_id";
    @VisibleForTesting
    static boolean enableRouteLookup = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_XDS_RLS_LB", true);
    @VisibleForTesting
    static boolean enableLeastRequest = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) ? Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) : Boolean.parseBoolean(System.getProperty("com.google.bigtable.repackaged.io.grpc.xds.experimentalEnableLeastRequest"));
    @VisibleForTesting
    static boolean enableWrr = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_XDS_WRR_LB", true);
    @VisibleForTesting
    static boolean enablePickFirst = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_PICKFIRST_LB_CONFIG", true);
    protected final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    static final String TYPE_URL_TYPED_STRUCT_UDPA = "type.googleapis.com/udpa.type.v1.TypedStruct";
    static final String TYPE_URL_TYPED_STRUCT = "type.googleapis.com/xds.type.v3.TypedStruct";

    @Nullable
    protected abstract String extractResourceName(Message var1);

    protected abstract Class<? extends Message> unpackedClassName();

    protected abstract String typeName();

    protected abstract String typeUrl();

    protected abstract boolean isFullStateOfTheWorld();

    ValidatedResourceUpdate<T> parse(Args args, List<Any> resources) {
        HashMap parsedResources = new HashMap(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            T resourceUpdate;
            Message unpackedMessage;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                unpackedMessage = XdsResourceType.unpackCompatibleType(resource, this.unpackedClassName(), this.typeUrl(), null);
            }
            catch (InvalidProtocolBufferException e) {
                errors.add(String.format("%s response Resource index %d - can't decode %s: %s", this.typeName(), i, this.unpackedClassName().getSimpleName(), e.getMessage()));
                continue;
            }
            String name = this.extractResourceName(unpackedMessage);
            if (name == null || !XdsClient.isResourceNameValid(name, resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + name + " for type: " + this.typeName());
                continue;
            }
            String cname = XdsClient.canonifyResourceName(name);
            if (args.subscribedResources != null && !args.subscribedResources.contains(name)) continue;
            unpackedResources.add(cname);
            try {
                resourceUpdate = this.doParse(args, unpackedMessage);
            }
            catch (ResourceInvalidException e) {
                errors.add(String.format("%s response %s '%s' validation error: %s", this.typeName(), this.unpackedClassName().getSimpleName(), cname, e.getMessage()));
                invalidResources.add(cname);
                continue;
            }
            parsedResources.put(cname, new ParsedResource<T>(resourceUpdate, resource));
        }
        return new ValidatedResourceUpdate(parsedResources, unpackedResources, invalidResources, errors);
    }

    protected abstract T doParse(Args var1, Message var2) throws ResourceInvalidException;

    static <T extends Message> T unpackCompatibleType(Any any, Class<T> clazz, String typeUrl, String compatibleTypeUrl) throws InvalidProtocolBufferException {
        if (any.getTypeUrl().equals(compatibleTypeUrl)) {
            any = any.toBuilder().setTypeUrl(typeUrl).build();
        }
        return any.unpack(clazz);
    }

    private Any maybeUnwrapResources(Any resource) throws InvalidProtocolBufferException {
        if (resource.getTypeUrl().equals(TYPE_URL_RESOURCE)) {
            return XdsResourceType.unpackCompatibleType(resource, Resource.class, TYPE_URL_RESOURCE, null).getResource();
        }
        return resource;
    }

    private static boolean getFlag(String envVarName, boolean enableByDefault) {
        String envVar = System.getenv(envVarName);
        if (enableByDefault) {
            return Strings.isNullOrEmpty(envVar) || Boolean.parseBoolean(envVar);
        }
        return !Strings.isNullOrEmpty(envVar) && Boolean.parseBoolean(envVar);
    }

    @VisibleForTesting
    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, "struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = Preconditions.checkNotNull(errorDetail, "errorDetail");
        }

        @Nullable
        @VisibleForTesting
        T getStruct() {
            return this.struct;
        }

        @Nullable
        @VisibleForTesting
        String getErrorDetail() {
            return this.errorDetail;
        }
    }

    static final class ValidatedResourceUpdate<T extends XdsClient.ResourceUpdate> {
        Map<String, ParsedResource<T>> parsedResources;
        Set<String> unpackedResources;
        Set<String> invalidResources;
        List<String> errors;

        public ValidatedResourceUpdate(Map<String, ParsedResource<T>> parsedResources, Set<String> unpackedResources, Set<String> invalidResources, List<String> errors) {
            this.parsedResources = parsedResources;
            this.unpackedResources = unpackedResources;
            this.invalidResources = invalidResources;
            this.errors = errors;
        }
    }

    static final class ParsedResource<T extends XdsClient.ResourceUpdate> {
        private final T resourceUpdate;
        private final Any rawResource;

        public ParsedResource(T resourceUpdate, Any rawResource) {
            this.resourceUpdate = (XdsClient.ResourceUpdate)Preconditions.checkNotNull(resourceUpdate, "resourceUpdate");
            this.rawResource = Preconditions.checkNotNull(rawResource, "rawResource");
        }

        T getResourceUpdate() {
            return this.resourceUpdate;
        }

        Any getRawResource() {
            return this.rawResource;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10847")
    public static final class ResourceInvalidException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public ResourceInvalidException(String message) {
            super(message, null, false, false);
        }

        public ResourceInvalidException(String message, Throwable cause) {
            super(cause != null ? message + ": " + cause.getMessage() : message, cause, false, false);
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10847")
    public static class Args {
        final Bootstrapper.ServerInfo serverInfo;
        final String versionInfo;
        final String nonce;
        final Bootstrapper.BootstrapInfo bootstrapInfo;
        final Object securityConfig;
        @Nullable
        final Set<String> subscribedResources;

        public Args(Bootstrapper.ServerInfo serverInfo, String versionInfo, String nonce, Bootstrapper.BootstrapInfo bootstrapInfo, Object securityConfig, @Nullable Set<String> subscribedResources) {
            this.serverInfo = serverInfo;
            this.versionInfo = versionInfo;
            this.nonce = nonce;
            this.bootstrapInfo = bootstrapInfo;
            this.securityConfig = securityConfig;
            this.subscribedResources = subscribedResources;
        }
    }
}

