/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.contrib.zpages;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Splitter;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.ZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.io.opencensus.trace.EndSpanOptions;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ZPageHttpHandler
implements HttpHandler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final String HTTP_SERVER = "HttpServer";
    private static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final ZPageHandler zpageHandler;
    private final String httpServerSpanName;

    ZPageHttpHandler(ZPageHandler zpageHandler) {
        this.zpageHandler = zpageHandler;
        this.httpServerSpanName = HTTP_SERVER + zpageHandler.getUrlPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpExchange httpExchange) throws IOException {
        Span span = tracer.spanBuilderWithExplicitParent(this.httpServerSpanName, null).setRecordEvents(true).startSpan();
        try (Scope ss = tracer.withSpan(span);){
            span.putAttribute("/http/method ", AttributeValue.stringAttributeValue(httpExchange.getRequestMethod()));
            httpExchange.sendResponseHeaders(200, 0L);
            this.zpageHandler.emitHtml(ZPageHttpHandler.uriQueryToMap(httpExchange.getRequestURI()), httpExchange.getResponseBody());
        }
        finally {
            httpExchange.close();
            span.end(END_SPAN_OPTIONS);
        }
    }

    @VisibleForTesting
    static Map<String, String> uriQueryToMap(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : Splitter.on("&").split(query)) {
            List<String> splits = Splitter.on("=").splitToList(param);
            if (splits.size() > 1) {
                result.put(splits.get(0), splits.get(1));
                continue;
            }
            result.put(splits.get(0), "");
        }
        return Collections.unmodifiableMap(result);
    }
}

