/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.internal;

import com.google.bigtable.repackaged.io.opentelemetry.api.internal.Contract;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    @Contract(value="null -> true")
    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String padLeft(String value, int minLength) {
        return StringUtils.padStart(value, minLength, '0');
    }

    private static String padStart(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    private StringUtils() {
    }
}

