/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.adapters.AppendAdapter;
import com.google.cloud.bigtable.hbase.adapters.DeleteAdapter;
import com.google.cloud.bigtable.hbase.adapters.HBaseMutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.IncrementAdapter;
import com.google.cloud.bigtable.hbase.adapters.PutAdapter;
import com.google.cloud.bigtable.hbase.adapters.UnsupportedMutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.BigtableWhileMatchResultScannerAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.GetAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowRangeAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ScanAdapter;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;

@InternalApi(value="For internal usage only")
public final class Adapters {
    public static final RowAdapter ROW_ADAPTER = new RowAdapter();
    public static final AppendAdapter APPEND_ADAPTER = new AppendAdapter();
    public static final IncrementAdapter INCREMENT_ADAPTER = new IncrementAdapter();
    public static final DeleteAdapter DELETE_ADAPTER = new DeleteAdapter();
    public static final FilterAdapter FILTER_ADAPTER = FilterAdapter.buildAdapter();
    public static final RowRangeAdapter ROW_RANGE_ADAPTER = new RowRangeAdapter();
    public static final ScanAdapter SCAN_ADAPTER = new ScanAdapter(FILTER_ADAPTER, ROW_RANGE_ADAPTER);
    public static final BigtableWhileMatchResultScannerAdapter BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER = new BigtableWhileMatchResultScannerAdapter();
    public static final GetAdapter GET_ADAPTER = new GetAdapter(SCAN_ADAPTER);

    public static HBaseMutationAdapter createMutationsAdapter(PutAdapter putAdapter) {
        return new HBaseMutationAdapter(DELETE_ADAPTER, putAdapter, new UnsupportedMutationAdapter<Increment>("increment"), new UnsupportedMutationAdapter<Append>("append"));
    }

    public static PutAdapter createPutAdapter(BigtableHBaseSettings settings) {
        Configuration config = settings.getConfiguration();
        boolean setClientTimestamp = !settings.isRetriesWithoutTimestampAllowed();
        return new PutAdapter(config.getInt("hbase.client.keyvalue.maxsize", -1), setClientTimestamp);
    }

    private Adapters() {
    }
}

