/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.hbase.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public abstract class SampledRowKeysAdapter {
    protected static final Logger LOG = new Logger(SampledRowKeysAdapter.class);
    protected final TableName tableName;
    protected final ServerName serverName;

    public SampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        this.tableName = tableName;
        this.serverName = serverName;
    }

    public List<HRegionLocation> adaptResponse(List<KeyOffset> responses) {
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>();
        byte[] startKey = HConstants.EMPTY_START_ROW;
        for (KeyOffset response : responses) {
            byte[] endKey = response.getKey().toByteArray();
            if (Bytes.equals((byte[])startKey, (byte[])endKey)) continue;
            regions.add(this.createRegionLocation(startKey, endKey));
            startKey = endKey;
        }
        byte[] endKey = HConstants.EMPTY_END_ROW;
        if (regions.isEmpty() || !Bytes.equals((byte[])startKey, (byte[])endKey)) {
            regions.add(this.createRegionLocation(startKey, endKey));
        }
        return regions;
    }

    protected abstract HRegionLocation createRegionLocation(byte[] var1, byte[] var2);
}

