/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableRangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.TreeRangeSet;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.SingleFilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.filters.UnsupportedStatusCollector;
import com.google.cloud.bigtable.hbase.util.RowKeyWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;

@InternalApi(value="For internal usage only")
public class FilterListAdapter
extends TypedFilterAdapterBase<FilterList>
implements UnsupportedStatusCollector<FilterList> {
    private final FilterAdapter subFilterAdapter;

    public FilterListAdapter(FilterAdapter subFilterAdapter) {
        this.subFilterAdapter = subFilterAdapter;
    }

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, FilterList filter) throws IOException {
        try (FilterAdapterContext.ContextCloseable ignored = context.beginFilterList(filter);){
            List<Filters.Filter> childFilters = this.collectChildFilters(context, filter);
            if (childFilters.isEmpty()) {
                Filters.Filter filter2 = null;
                return filter2;
            }
            if (childFilters.size() == 1) {
                Filters.Filter filter3 = childFilters.get(0);
                return filter3;
            }
            if (filter.getOperator() == FilterList.Operator.MUST_PASS_ALL) {
                Filters.ChainFilter chain = Filters.FILTERS.chain();
                for (Filters.Filter filterModel : childFilters) {
                    chain.filter(filterModel);
                }
                Filters.ChainFilter chainFilter = chain;
                return chainFilter;
            }
            Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
            for (Filters.Filter filterModel : childFilters) {
                interleave.filter(filterModel);
            }
            Filters.InterleaveFilter interleaveFilter = interleave;
            return interleaveFilter;
        }
    }

    List<Filters.Filter> collectChildFilters(FilterAdapterContext context, FilterList filter) throws IOException {
        ArrayList<Filters.Filter> result = new ArrayList<Filters.Filter>();
        for (Filter subFilter : filter.getFilters()) {
            Optional<Filters.Filter> potentialFilter = this.subFilterAdapter.adaptFilter(context, subFilter);
            if (!potentialFilter.isPresent()) continue;
            result.add(potentialFilter.get());
        }
        return result;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FilterList filter) {
        ArrayList<FilterSupportStatus> unsupportedSubfilters = new ArrayList<FilterSupportStatus>();
        try (FilterAdapterContext.ContextCloseable ignored = context.beginFilterList(filter);){
            this.collectUnsupportedStatuses(context, filter, (List<FilterSupportStatus>)unsupportedSubfilters);
        }
        if (unsupportedSubfilters.isEmpty()) {
            return FilterSupportStatus.SUPPORTED;
        }
        return FilterSupportStatus.newCompositeNotSupported(unsupportedSubfilters);
    }

    @Override
    public void collectUnsupportedStatuses(FilterAdapterContext context, FilterList filter, List<FilterSupportStatus> unsupportedStatuses) {
        for (Filter subFilter : filter.getFilters()) {
            this.subFilterAdapter.collectUnsupportedStatuses(context, subFilter, unsupportedStatuses);
        }
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(FilterList filter) {
        List<RangeSet<RowKeyWrapper>> childHints = this.collectChildHints(filter);
        if (childHints.isEmpty()) {
            return ImmutableRangeSet.of(Range.all());
        }
        if (childHints.size() == 1) {
            return childHints.get(0);
        }
        TreeRangeSet<RowKeyWrapper> result = TreeRangeSet.create(childHints.get(0));
        switch (filter.getOperator()) {
            case MUST_PASS_ONE: {
                for (int i = 1; i < childHints.size(); ++i) {
                    result.addAll((RangeSet)childHints.get(i));
                }
                break;
            }
            case MUST_PASS_ALL: {
                for (int i = 1; i < childHints.size(); ++i) {
                    result.removeAll((RangeSet)childHints.get(i).complement());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + filter.getOperator());
            }
        }
        return ImmutableRangeSet.copyOf(result);
    }

    private List<RangeSet<RowKeyWrapper>> collectChildHints(FilterList filter) {
        List subFilters = filter.getFilters();
        ArrayList<RangeSet<RowKeyWrapper>> hints = new ArrayList<RangeSet<RowKeyWrapper>>(subFilters.size());
        RangeSet<RowKeyWrapper> last = null;
        for (Filter subFilter : subFilters) {
            SingleFilterAdapter<?> subAdapter = this.subFilterAdapter.getAdapterForFilterOrThrow(subFilter);
            RangeSet<RowKeyWrapper> subRangeSet = subAdapter.getIndexScanHint(subFilter);
            if (last == subRangeSet) continue;
            hints.add(subRangeSet);
            last = subRangeSet;
        }
        return hints;
    }
}

