/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.admin;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.hbase.adapters.admin.ColumnDescriptorAdapter;
import com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;

@InternalApi(value="For internal usage only")
public class TableAdapter {
    private static final ColumnDescriptorAdapter columnDescriptorAdapter = ColumnDescriptorAdapter.INSTANCE;

    protected static void adapt(HTableDescriptor desc, CreateTableRequest request) {
        if (request != null) {
            for (HColumnDescriptor column : desc.getColumnFamilies()) {
                String columnName = column.getNameAsString();
                GCRules.GCRule gcRule = ColumnDescriptorAdapter.buildGarbageCollectionRule(column);
                if (gcRule == null) {
                    request.addFamily(columnName);
                    continue;
                }
                request.addFamily(columnName, gcRule);
            }
        }
    }

    public static CreateTableRequest adapt(HTableDescriptor desc, byte[][] splitKeys) {
        CreateTableRequest request = CreateTableRequest.of((String)desc.getTableName().getNameAsString());
        TableAdapter.adapt(desc, request);
        TableAdapter.addSplitKeys(splitKeys, request);
        return request;
    }

    public static void addSplitKeys(byte[][] splitKeys, CreateTableRequest request) {
        if (splitKeys != null) {
            for (byte[] splitKey : splitKeys) {
                request.addSplit(ByteString.copyFrom((byte[])splitKey));
            }
        }
    }

    private TableAdapter() {
    }

    public static HTableDescriptor adapt(Table table) {
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)table.getId()));
        for (ColumnFamily columnFamily : table.getColumnFamilies()) {
            tableDescriptor.addFamily(columnDescriptorAdapter.adapt(columnFamily));
        }
        return tableDescriptor;
    }
}

