/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class FamilyFilterAdapter
extends TypedFilterAdapterBase<FamilyFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, FamilyFilter filter) throws IOException {
        CompareFilter.CompareOp compareOp = filter.getOperator();
        if (compareOp != CompareFilter.CompareOp.EQUAL) {
            throw new IllegalStateException(String.format("Cannot adapt operator %s", compareOp == null ? null : compareOp.getClass().getCanonicalName()));
        }
        ByteArrayComparable comparator = filter.getComparator();
        String family = null;
        if (comparator == null) {
            throw new IllegalStateException("Comparator cannot be null");
        }
        if (comparator instanceof RegexStringComparator) {
            family = Bytes.toString((byte[])comparator.getValue());
            if (!family.isEmpty()) {
                family = ".*" + family + ".*";
            }
        } else if (comparator instanceof BinaryComparator) {
            ByteString quotedRegularExpression = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
            family = quotedRegularExpression.toStringUtf8();
        } else {
            throw new IllegalStateException("Cannot adapt comparator " + comparator.getClass().getCanonicalName());
        }
        return Filters.FILTERS.family().regex(family);
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FamilyFilter filter) {
        ByteArrayComparable comparator = filter.getComparator();
        if (!(comparator instanceof RegexStringComparator) && !(comparator instanceof BinaryComparator)) {
            return FilterSupportStatus.newNotSupported(comparator.getClass().getName() + " comparator is not supported");
        }
        if (filter.getOperator() != CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.newNotSupported(filter.getOperator() + " operator is not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

