/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.cloud.bigtable.hbase.BigtableFixedProtoScan;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.read.RowRangeAdapter;
import com.google.cloud.bigtable.hbase.util.RowKeyWrapper;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import com.google.common.base.Optional;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;

@InternalApi(value="For internal usage only")
public class ScanAdapter
implements ReadOperationAdapter<Scan> {
    private static final int UNSET_MAX_RESULTS_PER_COLUMN_FAMILY = -1;
    private static final boolean OPEN_CLOSED_AVAILABLE = ScanAdapter.isOpenClosedAvailable();
    private static final boolean LIMIT_AVAILABLE = ScanAdapter.isLimitAvailable();
    private static final boolean REVERSED_AVAILABLE = ScanAdapter.isReversedAvailable();
    private final FilterAdapter filterAdapter;
    private final RowRangeAdapter rowRangeAdapter;

    private static boolean isOpenClosedAvailable() {
        try {
            new Scan().includeStopRow();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private static boolean isLimitAvailable() {
        try {
            new Scan().setLimit(1);
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private static boolean isReversedAvailable() {
        try {
            new Scan().setReversed(true);
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    public ScanAdapter(FilterAdapter filterAdapter, RowRangeAdapter rowRangeAdapter) {
        this.filterAdapter = filterAdapter;
        this.rowRangeAdapter = rowRangeAdapter;
    }

    public void throwIfUnsupportedScan(Scan scan) {
        if (scan.getFilter() != null) {
            this.filterAdapter.throwIfUnsupportedFilter(scan, scan.getFilter());
        }
        if (scan.getMaxResultsPerColumnFamily() != -1) {
            throw new UnsupportedOperationException("Limiting of max results per column family is not supported.");
        }
    }

    public Filters.Filter buildFilter(Scan scan, ReadHooks hooks) {
        Optional<Filters.Filter> colFamilyTimeFilter;
        Filters.ChainFilter chain = Filters.FILTERS.chain();
        this.buildStartFilter(scan).forEach(arg_0 -> ((Filters.ChainFilter)chain).filter(arg_0));
        Optional<Filters.Filter> userFilter = this.createUserFilter(scan, hooks);
        if (userFilter.isPresent()) {
            chain.filter((Filters.Filter)userFilter.get());
        }
        if ((colFamilyTimeFilter = this.createColFamilyTimeRange(scan)).isPresent()) {
            chain.filter((Filters.Filter)colFamilyTimeFilter.get());
        }
        return chain;
    }

    private List<Filters.Filter> buildStartFilter(Scan scan) {
        ArrayList<Filters.Filter> filterList = new ArrayList<Filters.Filter>();
        Optional<Filters.Filter> familyFilter = this.createColumnFamilyFilter(scan);
        if (familyFilter.isPresent()) {
            filterList.add((Filters.Filter)familyFilter.get());
        }
        boolean hasTimeRange = false;
        if (scan.getTimeRange() != null && !scan.getTimeRange().isAllTime()) {
            filterList.add(this.createTimeRangeFilter(scan.getTimeRange()));
            hasTimeRange = true;
        }
        if (scan.getMaxVersions() != Integer.MAX_VALUE) {
            int i = hasTimeRange ? filterList.size() : 0;
            filterList.add(i, this.createColumnLimitFilter(scan.getMaxVersions()));
        }
        return filterList;
    }

    @Override
    public Query adapt(Scan scan, ReadHooks readHooks, Query query) {
        if (scan instanceof BigtableFixedProtoScan) {
            return Query.fromProto((ReadRowsRequest)((BigtableFixedProtoScan)scan).getRequest());
        }
        this.throwIfUnsupportedScan(scan);
        query.reversed(scan.isReversed());
        this.toByteStringRange(scan, query);
        query.filter(this.buildFilter(scan, readHooks));
        if (LIMIT_AVAILABLE && scan.getLimit() > 0) {
            query.limit((long)scan.getLimit());
        }
        return query;
    }

    private void toByteStringRange(Scan scan, Query query) {
        RangeSet<RowKeyWrapper> rangeSet = this.narrowRange(this.getRangeSet(scan), scan.getFilter());
        this.rowRangeAdapter.rangeSetToByteStringRange(rangeSet, query);
    }

    private RangeSet<RowKeyWrapper> getRangeSet(Scan scan) {
        BoundType stopBound;
        ByteString stopRow;
        BoundType startBound;
        ByteString startRow;
        if (scan instanceof BigtableExtendedScan) {
            RowSet rowSet = ((BigtableExtendedScan)scan).getRowSet();
            return this.rowRangeAdapter.rowSetToRangeSet(rowSet);
        }
        TreeRangeSet rangeSet = TreeRangeSet.create();
        if (scan.isGetScan()) {
            rangeSet.add(Range.singleton((Comparable)new RowKeyWrapper(ByteString.copyFrom((byte[])scan.getStartRow()))));
            return rangeSet;
        }
        if (REVERSED_AVAILABLE && scan.isReversed()) {
            startRow = ByteString.copyFrom((byte[])scan.getStopRow());
            startBound = !OPEN_CLOSED_AVAILABLE || !scan.includeStopRow() ? BoundType.OPEN : BoundType.CLOSED;
            stopRow = ByteString.copyFrom((byte[])scan.getStartRow());
            stopBound = !OPEN_CLOSED_AVAILABLE || scan.includeStartRow() ? BoundType.CLOSED : BoundType.OPEN;
        } else {
            startRow = ByteString.copyFrom((byte[])scan.getStartRow());
            startBound = !OPEN_CLOSED_AVAILABLE || scan.includeStartRow() ? BoundType.CLOSED : BoundType.OPEN;
            stopRow = ByteString.copyFrom((byte[])scan.getStopRow());
            stopBound = !OPEN_CLOSED_AVAILABLE || !scan.includeStopRow() ? BoundType.OPEN : BoundType.CLOSED;
        }
        rangeSet.add(this.rowRangeAdapter.boundedRange(startBound, startRow, stopBound, stopRow));
        return rangeSet;
    }

    private static ByteString quoteRegex(byte[] unquoted) {
        try {
            return ReaderExpressionHelper.quoteRegularExpression(unquoted);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when writing to ByteArrayOutputStream", e);
        }
    }

    private Optional<Filters.Filter> createUserFilter(Scan scan, ReadHooks hooks) {
        if (scan.getFilter() == null) {
            return Optional.absent();
        }
        try {
            return this.filterAdapter.adaptFilter(new FilterAdapterContext(scan, hooks), scan.getFilter());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to adapt filter", ioe);
        }
    }

    private RangeSet<RowKeyWrapper> narrowRange(RangeSet<RowKeyWrapper> rangeSet, Filter filter) {
        if (filter == null) {
            return rangeSet;
        }
        RangeSet<RowKeyWrapper> filterRangeSet = this.filterAdapter.getIndexScanHint(filter);
        if (filterRangeSet.encloses(Range.all())) {
            return rangeSet;
        }
        rangeSet.removeAll(filterRangeSet.complement());
        return rangeSet;
    }

    private Filters.Filter createColumnQualifierFilter(byte[] unquotedQualifier) {
        return Filters.FILTERS.qualifier().regex(ScanAdapter.quoteRegex(unquotedQualifier));
    }

    private Filters.Filter createFamilyFilter(byte[] familyName) {
        return Filters.FILTERS.family().exactMatch(new String(familyName));
    }

    private Filters.Filter createColumnLimitFilter(int maxVersionsPerColumn) {
        return Filters.FILTERS.limit().cellsPerColumn(maxVersionsPerColumn);
    }

    private Filters.Filter createTimeRangeFilter(TimeRange timeRange) {
        Filters.TimestampRangeFilter rangeBuilder = Filters.FILTERS.timestamp().range();
        rangeBuilder.startClosed((Object)this.convertUnits(timeRange.getMin()));
        if (timeRange.getMax() != Long.MAX_VALUE) {
            rangeBuilder.endOpen((Object)this.convertUnits(timeRange.getMax()));
        }
        return rangeBuilder;
    }

    private long convertUnits(long hbaseUnits) {
        return TimestampConverter.hbase2bigtable(hbaseUnits);
    }

    private Optional<Filters.Filter> createColumnFamilyFilter(Scan scan) {
        if (!scan.hasFamilies()) {
            return Optional.absent();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Map familyMap = scan.getFamilyMap();
        for (Map.Entry entry : familyMap.entrySet()) {
            Filters.Filter familyFilter = this.createFamilyFilter((byte[])entry.getKey());
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            if (qualifiers != null) {
                Filters.InterleaveFilter columnFilters = Filters.FILTERS.interleave();
                for (byte[] qualifier : qualifiers) {
                    columnFilters.filter(this.createColumnQualifierFilter(qualifier));
                }
                interleave.filter((Filters.Filter)Filters.FILTERS.chain().filter(familyFilter).filter((Filters.Filter)columnFilters));
                continue;
            }
            interleave.filter(familyFilter);
        }
        return Optional.of((Object)interleave);
    }

    private Optional<Filters.Filter> createColFamilyTimeRange(Scan scan) {
        if (scan.getColumnFamilyTimeRange().isEmpty()) {
            return Optional.absent();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Map range = scan.getColumnFamilyTimeRange();
        for (Map.Entry entry : range.entrySet()) {
            interleave.filter((Filters.Filter)Filters.FILTERS.chain().filter(this.createFamilyFilter((byte[])entry.getKey())).filter(this.createTimeRangeFilter((TimeRange)entry.getValue())));
        }
        return Optional.of((Object)interleave);
    }
}

