/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.api.core.InternalApi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@InternalApi(value="For internal usage only")
public class Logger {
    protected final Log log;

    public Logger(Class<?> logClass) {
        this.log = LogFactory.getLog(logClass);
    }

    public void trace(String message, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format(message, args));
        }
    }

    public void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format(message, args));
        }
    }

    public void debug(String message, Throwable t, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format(message, args), t);
        }
    }

    public void info(String message, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format(message, args));
        }
    }

    public void info(String message, Throwable t, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format(message, args), t);
        }
    }

    public void warn(String message, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)String.format(message, args));
        }
    }

    public void warn(String message, Throwable t, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)String.format(message, args), t);
        }
    }

    public void error(String message, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)String.format(message, args));
        }
    }

    public void error(String message, Throwable t, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)String.format(message, args), t);
        }
    }

    public void fatal(String message, Object ... args) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)String.format(message, args));
        }
    }

    public void fatal(String message, Throwable t, Object ... args) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)String.format(message, args), t);
        }
    }

    public Log getLog() {
        return this.log;
    }
}

