/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.core.NanoClock;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi(value="For internal usage only")
public class OperationAccountant {
    private static Logger LOG = new Logger(OperationAccountant.class);
    private static final long DEFAULT_FINISH_WAIT_MILLIS = 250L;
    private static final long INTERVAL_NO_SUCCESS_WARNING_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final ApiClock clock;
    private final long finishWaitMillis;
    private final Object signal = new String("");
    private AtomicInteger count = new AtomicInteger();
    private long noSuccessCheckDeadlineNanos;
    private int noSuccessWarningCount;

    public OperationAccountant() {
        this(NanoClock.getDefaultClock(), 250L);
    }

    @VisibleForTesting
    OperationAccountant(ApiClock clock, long finishWaitMillis) {
        this.clock = clock;
        this.finishWaitMillis = finishWaitMillis;
        this.resetNoSuccessWarningDeadline();
    }

    public void registerOperation(ApiFuture<?> future) {
        this.count.incrementAndGet();
        ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<Object>(){

            public void onSuccess(Object result) {
                OperationAccountant.this.onOperationCompletion();
            }

            public void onFailure(Throwable t) {
                OperationAccountant.this.onOperationCompletion();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() throws InterruptedException {
        boolean performedWarning = false;
        while (this.hasInflightOperations()) {
            Object object = this.signal;
            synchronized (object) {
                if (this.hasInflightOperations()) {
                    this.signal.wait(this.finishWaitMillis);
                }
            }
            long now = this.clock.nanoTime();
            if (now < this.noSuccessCheckDeadlineNanos) continue;
            this.logNoSuccessWarning(now);
            this.resetNoSuccessWarningDeadline();
            performedWarning = true;
        }
        if (performedWarning) {
            LOG.info("awaitCompletion() completed", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onOperationCompletion() {
        this.resetNoSuccessWarningDeadline();
        if (this.count.decrementAndGet() == 0) {
            Object object = this.signal;
            synchronized (object) {
                this.signal.notifyAll();
            }
        }
        return true;
    }

    private void logNoSuccessWarning(long now) {
        long lastUpdateNanos = now - this.noSuccessCheckDeadlineNanos + INTERVAL_NO_SUCCESS_WARNING_NANOS;
        long lastUpdated = TimeUnit.NANOSECONDS.toSeconds(lastUpdateNanos);
        LOG.warn("No operations completed within the last %d seconds. There are still %d operations in progress.", lastUpdated, this.count.get());
        ++this.noSuccessWarningCount;
    }

    public boolean hasInflightOperations() {
        return this.count.get() > 0;
    }

    private void resetNoSuccessWarningDeadline() {
        this.noSuccessCheckDeadlineNanos = this.clock.nanoTime() + INTERVAL_NO_SUCCESS_WARNING_NANOS;
    }

    @VisibleForTesting
    int getNoSuccessWarningCount() {
        return this.noSuccessWarningCount;
    }
}

