/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

@InternalApi(value="For internal usage only")
public abstract class BigtableHBaseSettings {
    protected static final Logger LOG = new Logger(BigtableOptionsFactory.class);
    private final Configuration configuration;
    private final String projectId;
    private final String instanceId;
    private final int ttlSecondsForBackup;
    @VisibleForTesting
    public static final String BULK_MUTATION_CLOSE_TIMEOUT_MILLISECONDS = "bulk.mutation.close.timeout.milliseconds";
    private final long bulkMutationCloseTimeoutMilliseconds;

    public static BigtableHBaseSettings create(Configuration configuration) throws IOException {
        return BigtableHBaseVeneerSettings.create(configuration);
    }

    public BigtableHBaseSettings(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        this.projectId = this.getRequiredValue("google.bigtable.project.id", "Project ID");
        this.instanceId = this.getRequiredValue("google.bigtable.instance.id", "Instance ID");
        this.ttlSecondsForBackup = configuration.getInt("google.bigtable.snapshot.default.ttl.secs", 86400);
        this.bulkMutationCloseTimeoutMilliseconds = configuration.getLong(BULK_MUTATION_CLOSE_TIMEOUT_MILLISECONDS, 0L);
        Preconditions.checkArgument((this.bulkMutationCloseTimeoutMilliseconds >= 0L ? 1 : 0) != 0);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getTtlSecondsForBackup() {
        return this.ttlSecondsForBackup;
    }

    public abstract String getDataHost();

    public abstract String getAdminHost();

    public abstract int getPort();

    public abstract int getBulkMaxRowCount();

    public abstract long getBatchingMaxRequestSize();

    public abstract boolean isRetriesWithoutTimestampAllowed();

    public long getBulkMutationCloseTimeoutMilliseconds() {
        return this.bulkMutationCloseTimeoutMilliseconds;
    }

    protected String getRequiredValue(String key, String displayName) {
        String value = this.configuration.get(key);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)String.format("%s must be supplied via %s", displayName, key));
        return value;
    }

    public abstract String toDebugString();

    public abstract Map<String, String> toDebugStrings();
}

