/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.r2dbc.ConversionFailureException;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibrariesConverter;

class LongIntegerConverter
implements SpannerClientLibrariesConverter<Integer> {
    LongIntegerConverter() {
    }

    @Override
    public boolean canConvert(Class<?> inputClass, Class<?> resultClass) {
        return inputClass == Long.class && resultClass == Integer.class;
    }

    @Override
    public Integer convert(Object input) {
        if (!this.canConvert(input.getClass(), Integer.class)) {
            throw new ConversionFailureException(String.format("Unable to convert %s to %s", input.getClass().getClass(), Integer.class));
        }
        long val = (Long)input;
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw new ConversionFailureException(String.format("%d is out of range for Integer", val));
        }
        return (int)val;
    }
}

