/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.r2dbc.v2.SpannerConstants;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.TransactionDefinition;
import java.util.HashMap;
import java.util.Map;

public class SpannerTransactionDefinition
implements TransactionDefinition {
    private final Map<Option<?>, Object> internalMap;

    SpannerTransactionDefinition(Map<Option<?>, Object> internalMap) {
        this.validate(internalMap);
        this.internalMap = internalMap;
    }

    private void validate(Map<Option<?>, Object> internalMap) {
        boolean isReadOnlyTransaction = Boolean.TRUE.equals(internalMap.get(READ_ONLY));
        if (!isReadOnlyTransaction && internalMap.containsKey(SpannerConstants.TIMESTAMP_BOUND)) {
            throw new IllegalArgumentException("TIMESTAMP_BOUND can only be configured for read only transactions.");
        }
    }

    public <T> T getAttribute(Option<T> option) {
        return (T)this.internalMap.get(option);
    }

    public static class Builder {
        private final Map<Option<?>, Object> internalMap = new HashMap();

        public <T> Builder with(Option<T> option, T value) {
            this.internalMap.put(option, value);
            return this;
        }

        public SpannerTransactionDefinition build() {
            return new SpannerTransactionDefinition(this.internalMap);
        }
    }
}

