/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateExampleStoreOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateExampleStoreRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteExampleStoreOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteExampleStoreRequest;
import com.google.cloud.aiplatform.v1beta1.Example;
import com.google.cloud.aiplatform.v1beta1.ExampleStore;
import com.google.cloud.aiplatform.v1beta1.ExampleStoreName;
import com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceSettings;
import com.google.cloud.aiplatform.v1beta1.FetchExamplesRequest;
import com.google.cloud.aiplatform.v1beta1.FetchExamplesResponse;
import com.google.cloud.aiplatform.v1beta1.GetExampleStoreRequest;
import com.google.cloud.aiplatform.v1beta1.ListExampleStoresRequest;
import com.google.cloud.aiplatform.v1beta1.ListExampleStoresResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.RemoveExamplesRequest;
import com.google.cloud.aiplatform.v1beta1.RemoveExamplesResponse;
import com.google.cloud.aiplatform.v1beta1.SearchExamplesRequest;
import com.google.cloud.aiplatform.v1beta1.SearchExamplesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateExampleStoreOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateExampleStoreRequest;
import com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest;
import com.google.cloud.aiplatform.v1beta1.UpsertExamplesResponse;
import com.google.cloud.aiplatform.v1beta1.stub.ExampleStoreServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ExampleStoreServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExampleStoreServiceClient
implements BackgroundResource {
    private final ExampleStoreServiceSettings settings;
    private final ExampleStoreServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ExampleStoreServiceClient create() throws IOException {
        return ExampleStoreServiceClient.create(ExampleStoreServiceSettings.newBuilder().build());
    }

    public static final ExampleStoreServiceClient create(ExampleStoreServiceSettings settings) throws IOException {
        return new ExampleStoreServiceClient(settings);
    }

    public static final ExampleStoreServiceClient create(ExampleStoreServiceStub stub) {
        return new ExampleStoreServiceClient(stub);
    }

    protected ExampleStoreServiceClient(ExampleStoreServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExampleStoreServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ExampleStoreServiceClient(ExampleStoreServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ExampleStoreServiceSettings getSettings() {
        return this.settings;
    }

    public ExampleStoreServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<ExampleStore, CreateExampleStoreOperationMetadata> createExampleStoreAsync(LocationName parent, ExampleStore exampleStore) {
        CreateExampleStoreRequest request = CreateExampleStoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExampleStore(exampleStore).build();
        return this.createExampleStoreAsync(request);
    }

    public final OperationFuture<ExampleStore, CreateExampleStoreOperationMetadata> createExampleStoreAsync(String parent, ExampleStore exampleStore) {
        CreateExampleStoreRequest request = CreateExampleStoreRequest.newBuilder().setParent(parent).setExampleStore(exampleStore).build();
        return this.createExampleStoreAsync(request);
    }

    public final OperationFuture<ExampleStore, CreateExampleStoreOperationMetadata> createExampleStoreAsync(CreateExampleStoreRequest request) {
        return this.createExampleStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExampleStoreRequest, ExampleStore, CreateExampleStoreOperationMetadata> createExampleStoreOperationCallable() {
        return this.stub.createExampleStoreOperationCallable();
    }

    public final UnaryCallable<CreateExampleStoreRequest, Operation> createExampleStoreCallable() {
        return this.stub.createExampleStoreCallable();
    }

    public final ExampleStore getExampleStore(ExampleStoreName name) {
        GetExampleStoreRequest request = GetExampleStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExampleStore(request);
    }

    public final ExampleStore getExampleStore(String name) {
        GetExampleStoreRequest request = GetExampleStoreRequest.newBuilder().setName(name).build();
        return this.getExampleStore(request);
    }

    public final ExampleStore getExampleStore(GetExampleStoreRequest request) {
        return (ExampleStore)this.getExampleStoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetExampleStoreRequest, ExampleStore> getExampleStoreCallable() {
        return this.stub.getExampleStoreCallable();
    }

    public final OperationFuture<ExampleStore, UpdateExampleStoreOperationMetadata> updateExampleStoreAsync(ExampleStore exampleStore, FieldMask updateMask) {
        UpdateExampleStoreRequest request = UpdateExampleStoreRequest.newBuilder().setExampleStore(exampleStore).setUpdateMask(updateMask).build();
        return this.updateExampleStoreAsync(request);
    }

    public final OperationFuture<ExampleStore, UpdateExampleStoreOperationMetadata> updateExampleStoreAsync(UpdateExampleStoreRequest request) {
        return this.updateExampleStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateExampleStoreRequest, ExampleStore, UpdateExampleStoreOperationMetadata> updateExampleStoreOperationCallable() {
        return this.stub.updateExampleStoreOperationCallable();
    }

    public final UnaryCallable<UpdateExampleStoreRequest, Operation> updateExampleStoreCallable() {
        return this.stub.updateExampleStoreCallable();
    }

    public final OperationFuture<Empty, DeleteExampleStoreOperationMetadata> deleteExampleStoreAsync(ExampleStoreName name) {
        DeleteExampleStoreRequest request = DeleteExampleStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExampleStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteExampleStoreOperationMetadata> deleteExampleStoreAsync(String name) {
        DeleteExampleStoreRequest request = DeleteExampleStoreRequest.newBuilder().setName(name).build();
        return this.deleteExampleStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteExampleStoreOperationMetadata> deleteExampleStoreAsync(DeleteExampleStoreRequest request) {
        return this.deleteExampleStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExampleStoreRequest, Empty, DeleteExampleStoreOperationMetadata> deleteExampleStoreOperationCallable() {
        return this.stub.deleteExampleStoreOperationCallable();
    }

    public final UnaryCallable<DeleteExampleStoreRequest, Operation> deleteExampleStoreCallable() {
        return this.stub.deleteExampleStoreCallable();
    }

    public final ListExampleStoresPagedResponse listExampleStores(LocationName parent) {
        ListExampleStoresRequest request = ListExampleStoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExampleStores(request);
    }

    public final ListExampleStoresPagedResponse listExampleStores(String parent) {
        ListExampleStoresRequest request = ListExampleStoresRequest.newBuilder().setParent(parent).build();
        return this.listExampleStores(request);
    }

    public final ListExampleStoresPagedResponse listExampleStores(ListExampleStoresRequest request) {
        return (ListExampleStoresPagedResponse)((Object)this.listExampleStoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExampleStoresRequest, ListExampleStoresPagedResponse> listExampleStoresPagedCallable() {
        return this.stub.listExampleStoresPagedCallable();
    }

    public final UnaryCallable<ListExampleStoresRequest, ListExampleStoresResponse> listExampleStoresCallable() {
        return this.stub.listExampleStoresCallable();
    }

    public final UpsertExamplesResponse upsertExamples(UpsertExamplesRequest request) {
        return (UpsertExamplesResponse)this.upsertExamplesCallable().call((Object)request);
    }

    public final UnaryCallable<UpsertExamplesRequest, UpsertExamplesResponse> upsertExamplesCallable() {
        return this.stub.upsertExamplesCallable();
    }

    public final RemoveExamplesResponse removeExamples(RemoveExamplesRequest request) {
        return (RemoveExamplesResponse)this.removeExamplesCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveExamplesRequest, RemoveExamplesResponse> removeExamplesCallable() {
        return this.stub.removeExamplesCallable();
    }

    public final SearchExamplesResponse searchExamples(SearchExamplesRequest request) {
        return (SearchExamplesResponse)this.searchExamplesCallable().call((Object)request);
    }

    public final UnaryCallable<SearchExamplesRequest, SearchExamplesResponse> searchExamplesCallable() {
        return this.stub.searchExamplesCallable();
    }

    public final FetchExamplesPagedResponse fetchExamples(FetchExamplesRequest request) {
        return (FetchExamplesPagedResponse)((Object)this.fetchExamplesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchExamplesRequest, FetchExamplesPagedResponse> fetchExamplesPagedCallable() {
        return this.stub.fetchExamplesPagedCallable();
    }

    public final UnaryCallable<FetchExamplesRequest, FetchExamplesResponse> fetchExamplesCallable() {
        return this.stub.fetchExamplesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchExamplesFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchExamplesRequest, FetchExamplesResponse, Example, FetchExamplesPage, FetchExamplesFixedSizeCollection> {
        private FetchExamplesFixedSizeCollection(List<FetchExamplesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchExamplesFixedSizeCollection createEmptyCollection() {
            return new FetchExamplesFixedSizeCollection(null, 0);
        }

        protected FetchExamplesFixedSizeCollection createCollection(List<FetchExamplesPage> pages, int collectionSize) {
            return new FetchExamplesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchExamplesPage
    extends AbstractPage<FetchExamplesRequest, FetchExamplesResponse, Example, FetchExamplesPage> {
        private FetchExamplesPage(PageContext<FetchExamplesRequest, FetchExamplesResponse, Example> context, FetchExamplesResponse response) {
            super(context, (Object)response);
        }

        private static FetchExamplesPage createEmptyPage() {
            return new FetchExamplesPage(null, null);
        }

        protected FetchExamplesPage createPage(PageContext<FetchExamplesRequest, FetchExamplesResponse, Example> context, FetchExamplesResponse response) {
            return new FetchExamplesPage(context, response);
        }

        public ApiFuture<FetchExamplesPage> createPageAsync(PageContext<FetchExamplesRequest, FetchExamplesResponse, Example> context, ApiFuture<FetchExamplesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchExamplesPagedResponse
    extends AbstractPagedListResponse<FetchExamplesRequest, FetchExamplesResponse, Example, FetchExamplesPage, FetchExamplesFixedSizeCollection> {
        public static ApiFuture<FetchExamplesPagedResponse> createAsync(PageContext<FetchExamplesRequest, FetchExamplesResponse, Example> context, ApiFuture<FetchExamplesResponse> futureResponse) {
            ApiFuture<FetchExamplesPage> futurePage = FetchExamplesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchExamplesPagedResponse((FetchExamplesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchExamplesPagedResponse(FetchExamplesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchExamplesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExampleStoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore, ListExampleStoresPage, ListExampleStoresFixedSizeCollection> {
        private ListExampleStoresFixedSizeCollection(List<ListExampleStoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExampleStoresFixedSizeCollection createEmptyCollection() {
            return new ListExampleStoresFixedSizeCollection(null, 0);
        }

        protected ListExampleStoresFixedSizeCollection createCollection(List<ListExampleStoresPage> pages, int collectionSize) {
            return new ListExampleStoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExampleStoresPage
    extends AbstractPage<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore, ListExampleStoresPage> {
        private ListExampleStoresPage(PageContext<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore> context, ListExampleStoresResponse response) {
            super(context, (Object)response);
        }

        private static ListExampleStoresPage createEmptyPage() {
            return new ListExampleStoresPage(null, null);
        }

        protected ListExampleStoresPage createPage(PageContext<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore> context, ListExampleStoresResponse response) {
            return new ListExampleStoresPage(context, response);
        }

        public ApiFuture<ListExampleStoresPage> createPageAsync(PageContext<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore> context, ApiFuture<ListExampleStoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExampleStoresPagedResponse
    extends AbstractPagedListResponse<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore, ListExampleStoresPage, ListExampleStoresFixedSizeCollection> {
        public static ApiFuture<ListExampleStoresPagedResponse> createAsync(PageContext<ListExampleStoresRequest, ListExampleStoresResponse, ExampleStore> context, ApiFuture<ListExampleStoresResponse> futureResponse) {
            ApiFuture<ListExampleStoresPage> futurePage = ListExampleStoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExampleStoresPagedResponse((ListExampleStoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExampleStoresPagedResponse(ListExampleStoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExampleStoresFixedSizeCollection.createEmptyCollection());
        }
    }
}

