/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AcceptPublisherModelEulaRequest;
import com.google.cloud.aiplatform.v1beta1.CheckPublisherModelEulaAcceptanceRequest;
import com.google.cloud.aiplatform.v1beta1.DeployOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelResponse;
import com.google.cloud.aiplatform.v1beta1.DeployRequest;
import com.google.cloud.aiplatform.v1beta1.DeployResponse;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelResponse;
import com.google.cloud.aiplatform.v1beta1.GetPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.ListPublisherModelsRequest;
import com.google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse;
import com.google.cloud.aiplatform.v1beta1.ModelGardenServiceSettings;
import com.google.cloud.aiplatform.v1beta1.ProjectName;
import com.google.cloud.aiplatform.v1beta1.PublisherModel;
import com.google.cloud.aiplatform.v1beta1.PublisherModelEulaAcceptance;
import com.google.cloud.aiplatform.v1beta1.PublisherModelName;
import com.google.cloud.aiplatform.v1beta1.stub.ModelGardenServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ModelGardenServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ModelGardenServiceClient
implements BackgroundResource {
    private final ModelGardenServiceSettings settings;
    private final ModelGardenServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ModelGardenServiceClient create() throws IOException {
        return ModelGardenServiceClient.create(ModelGardenServiceSettings.newBuilder().build());
    }

    public static final ModelGardenServiceClient create(ModelGardenServiceSettings settings) throws IOException {
        return new ModelGardenServiceClient(settings);
    }

    public static final ModelGardenServiceClient create(ModelGardenServiceStub stub) {
        return new ModelGardenServiceClient(stub);
    }

    protected ModelGardenServiceClient(ModelGardenServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelGardenServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ModelGardenServiceClient(ModelGardenServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ModelGardenServiceSettings getSettings() {
        return this.settings;
    }

    public ModelGardenServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final PublisherModel getPublisherModel(PublisherModelName name) {
        GetPublisherModelRequest request = GetPublisherModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPublisherModel(request);
    }

    public final PublisherModel getPublisherModel(String name) {
        GetPublisherModelRequest request = GetPublisherModelRequest.newBuilder().setName(name).build();
        return this.getPublisherModel(request);
    }

    public final PublisherModel getPublisherModel(GetPublisherModelRequest request) {
        return (PublisherModel)this.getPublisherModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetPublisherModelRequest, PublisherModel> getPublisherModelCallable() {
        return this.stub.getPublisherModelCallable();
    }

    public final ListPublisherModelsPagedResponse listPublisherModels(String parent) {
        ListPublisherModelsRequest request = ListPublisherModelsRequest.newBuilder().setParent(parent).build();
        return this.listPublisherModels(request);
    }

    public final ListPublisherModelsPagedResponse listPublisherModels(ListPublisherModelsRequest request) {
        return (ListPublisherModelsPagedResponse)((Object)this.listPublisherModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsPagedResponse> listPublisherModelsPagedCallable() {
        return this.stub.listPublisherModelsPagedCallable();
    }

    public final UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsResponse> listPublisherModelsCallable() {
        return this.stub.listPublisherModelsCallable();
    }

    public final OperationFuture<DeployResponse, DeployOperationMetadata> deployAsync(DeployRequest request) {
        return this.deployOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployRequest, DeployResponse, DeployOperationMetadata> deployOperationCallable() {
        return this.stub.deployOperationCallable();
    }

    public final UnaryCallable<DeployRequest, Operation> deployCallable() {
        return this.stub.deployCallable();
    }

    @Deprecated
    public final OperationFuture<DeployPublisherModelResponse, DeployPublisherModelOperationMetadata> deployPublisherModelAsync(DeployPublisherModelRequest request) {
        return this.deployPublisherModelOperationCallable().futureCall((Object)request);
    }

    @Deprecated
    public final OperationCallable<DeployPublisherModelRequest, DeployPublisherModelResponse, DeployPublisherModelOperationMetadata> deployPublisherModelOperationCallable() {
        return this.stub.deployPublisherModelOperationCallable();
    }

    @Deprecated
    public final UnaryCallable<DeployPublisherModelRequest, Operation> deployPublisherModelCallable() {
        return this.stub.deployPublisherModelCallable();
    }

    public final OperationFuture<ExportPublisherModelResponse, ExportPublisherModelOperationMetadata> exportPublisherModelAsync(ExportPublisherModelRequest request) {
        return this.exportPublisherModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportPublisherModelRequest, ExportPublisherModelResponse, ExportPublisherModelOperationMetadata> exportPublisherModelOperationCallable() {
        return this.stub.exportPublisherModelOperationCallable();
    }

    public final UnaryCallable<ExportPublisherModelRequest, Operation> exportPublisherModelCallable() {
        return this.stub.exportPublisherModelCallable();
    }

    public final PublisherModelEulaAcceptance checkPublisherModelEulaAcceptance(ProjectName parent, PublisherModelName publisherModel) {
        CheckPublisherModelEulaAcceptanceRequest request = CheckPublisherModelEulaAcceptanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPublisherModel(publisherModel == null ? null : publisherModel.toString()).build();
        return this.checkPublisherModelEulaAcceptance(request);
    }

    public final PublisherModelEulaAcceptance checkPublisherModelEulaAcceptance(ProjectName parent, String publisherModel) {
        CheckPublisherModelEulaAcceptanceRequest request = CheckPublisherModelEulaAcceptanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPublisherModel(publisherModel).build();
        return this.checkPublisherModelEulaAcceptance(request);
    }

    public final PublisherModelEulaAcceptance checkPublisherModelEulaAcceptance(String parent, PublisherModelName publisherModel) {
        CheckPublisherModelEulaAcceptanceRequest request = CheckPublisherModelEulaAcceptanceRequest.newBuilder().setParent(parent).setPublisherModel(publisherModel == null ? null : publisherModel.toString()).build();
        return this.checkPublisherModelEulaAcceptance(request);
    }

    public final PublisherModelEulaAcceptance checkPublisherModelEulaAcceptance(String parent, String publisherModel) {
        CheckPublisherModelEulaAcceptanceRequest request = CheckPublisherModelEulaAcceptanceRequest.newBuilder().setParent(parent).setPublisherModel(publisherModel).build();
        return this.checkPublisherModelEulaAcceptance(request);
    }

    public final PublisherModelEulaAcceptance checkPublisherModelEulaAcceptance(CheckPublisherModelEulaAcceptanceRequest request) {
        return (PublisherModelEulaAcceptance)this.checkPublisherModelEulaAcceptanceCallable().call((Object)request);
    }

    public final UnaryCallable<CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance> checkPublisherModelEulaAcceptanceCallable() {
        return this.stub.checkPublisherModelEulaAcceptanceCallable();
    }

    public final PublisherModelEulaAcceptance acceptPublisherModelEula(ProjectName parent, PublisherModelName publisherModel) {
        AcceptPublisherModelEulaRequest request = AcceptPublisherModelEulaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPublisherModel(publisherModel == null ? null : publisherModel.toString()).build();
        return this.acceptPublisherModelEula(request);
    }

    public final PublisherModelEulaAcceptance acceptPublisherModelEula(ProjectName parent, String publisherModel) {
        AcceptPublisherModelEulaRequest request = AcceptPublisherModelEulaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPublisherModel(publisherModel).build();
        return this.acceptPublisherModelEula(request);
    }

    public final PublisherModelEulaAcceptance acceptPublisherModelEula(String parent, PublisherModelName publisherModel) {
        AcceptPublisherModelEulaRequest request = AcceptPublisherModelEulaRequest.newBuilder().setParent(parent).setPublisherModel(publisherModel == null ? null : publisherModel.toString()).build();
        return this.acceptPublisherModelEula(request);
    }

    public final PublisherModelEulaAcceptance acceptPublisherModelEula(String parent, String publisherModel) {
        AcceptPublisherModelEulaRequest request = AcceptPublisherModelEulaRequest.newBuilder().setParent(parent).setPublisherModel(publisherModel).build();
        return this.acceptPublisherModelEula(request);
    }

    public final PublisherModelEulaAcceptance acceptPublisherModelEula(AcceptPublisherModelEulaRequest request) {
        return (PublisherModelEulaAcceptance)this.acceptPublisherModelEulaCallable().call((Object)request);
    }

    public final UnaryCallable<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance> acceptPublisherModelEulaCallable() {
        return this.stub.acceptPublisherModelEulaCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPublisherModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel, ListPublisherModelsPage, ListPublisherModelsFixedSizeCollection> {
        private ListPublisherModelsFixedSizeCollection(List<ListPublisherModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPublisherModelsFixedSizeCollection createEmptyCollection() {
            return new ListPublisherModelsFixedSizeCollection(null, 0);
        }

        protected ListPublisherModelsFixedSizeCollection createCollection(List<ListPublisherModelsPage> pages, int collectionSize) {
            return new ListPublisherModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPublisherModelsPage
    extends AbstractPage<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel, ListPublisherModelsPage> {
        private ListPublisherModelsPage(PageContext<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel> context, ListPublisherModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListPublisherModelsPage createEmptyPage() {
            return new ListPublisherModelsPage(null, null);
        }

        protected ListPublisherModelsPage createPage(PageContext<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel> context, ListPublisherModelsResponse response) {
            return new ListPublisherModelsPage(context, response);
        }

        public ApiFuture<ListPublisherModelsPage> createPageAsync(PageContext<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel> context, ApiFuture<ListPublisherModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPublisherModelsPagedResponse
    extends AbstractPagedListResponse<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel, ListPublisherModelsPage, ListPublisherModelsFixedSizeCollection> {
        public static ApiFuture<ListPublisherModelsPagedResponse> createAsync(PageContext<ListPublisherModelsRequest, ListPublisherModelsResponse, PublisherModel> context, ApiFuture<ListPublisherModelsResponse> futureResponse) {
            ApiFuture<ListPublisherModelsPage> futurePage = ListPublisherModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPublisherModelsPagedResponse((ListPublisherModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPublisherModelsPagedResponse(ListPublisherModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPublisherModelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

