/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateModelMonitorOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateModelMonitorRequest;
import com.google.cloud.aiplatform.v1beta1.CreateModelMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteModelMonitorRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteModelMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetModelMonitorRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelMonitoringJobRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelMonitoringJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelMonitoringJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelMonitorsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelMonitorsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.ModelMonitor;
import com.google.cloud.aiplatform.v1beta1.ModelMonitorName;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlert;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobName;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringServiceSettings;
import com.google.cloud.aiplatform.v1beta1.ModelMonitoringStats;
import com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsRequest;
import com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringAlertsResponse;
import com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsRequest;
import com.google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateModelMonitorOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateModelMonitorRequest;
import com.google.cloud.aiplatform.v1beta1.stub.ModelMonitoringServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ModelMonitoringServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ModelMonitoringServiceClient
implements BackgroundResource {
    private final ModelMonitoringServiceSettings settings;
    private final ModelMonitoringServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ModelMonitoringServiceClient create() throws IOException {
        return ModelMonitoringServiceClient.create(ModelMonitoringServiceSettings.newBuilder().build());
    }

    public static final ModelMonitoringServiceClient create(ModelMonitoringServiceSettings settings) throws IOException {
        return new ModelMonitoringServiceClient(settings);
    }

    public static final ModelMonitoringServiceClient create(ModelMonitoringServiceStub stub) {
        return new ModelMonitoringServiceClient(stub);
    }

    protected ModelMonitoringServiceClient(ModelMonitoringServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelMonitoringServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ModelMonitoringServiceClient(ModelMonitoringServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ModelMonitoringServiceSettings getSettings() {
        return this.settings;
    }

    public ModelMonitoringServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<ModelMonitor, CreateModelMonitorOperationMetadata> createModelMonitorAsync(LocationName parent, ModelMonitor modelMonitor) {
        CreateModelMonitorRequest request = CreateModelMonitorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModelMonitor(modelMonitor).build();
        return this.createModelMonitorAsync(request);
    }

    public final OperationFuture<ModelMonitor, CreateModelMonitorOperationMetadata> createModelMonitorAsync(String parent, ModelMonitor modelMonitor) {
        CreateModelMonitorRequest request = CreateModelMonitorRequest.newBuilder().setParent(parent).setModelMonitor(modelMonitor).build();
        return this.createModelMonitorAsync(request);
    }

    public final OperationFuture<ModelMonitor, CreateModelMonitorOperationMetadata> createModelMonitorAsync(CreateModelMonitorRequest request) {
        return this.createModelMonitorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateModelMonitorRequest, ModelMonitor, CreateModelMonitorOperationMetadata> createModelMonitorOperationCallable() {
        return this.stub.createModelMonitorOperationCallable();
    }

    public final UnaryCallable<CreateModelMonitorRequest, Operation> createModelMonitorCallable() {
        return this.stub.createModelMonitorCallable();
    }

    public final OperationFuture<ModelMonitor, UpdateModelMonitorOperationMetadata> updateModelMonitorAsync(ModelMonitor modelMonitor, FieldMask updateMask) {
        UpdateModelMonitorRequest request = UpdateModelMonitorRequest.newBuilder().setModelMonitor(modelMonitor).setUpdateMask(updateMask).build();
        return this.updateModelMonitorAsync(request);
    }

    public final OperationFuture<ModelMonitor, UpdateModelMonitorOperationMetadata> updateModelMonitorAsync(UpdateModelMonitorRequest request) {
        return this.updateModelMonitorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateModelMonitorRequest, ModelMonitor, UpdateModelMonitorOperationMetadata> updateModelMonitorOperationCallable() {
        return this.stub.updateModelMonitorOperationCallable();
    }

    public final UnaryCallable<UpdateModelMonitorRequest, Operation> updateModelMonitorCallable() {
        return this.stub.updateModelMonitorCallable();
    }

    public final ModelMonitor getModelMonitor(ModelMonitorName name) {
        GetModelMonitorRequest request = GetModelMonitorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelMonitor(request);
    }

    public final ModelMonitor getModelMonitor(String name) {
        GetModelMonitorRequest request = GetModelMonitorRequest.newBuilder().setName(name).build();
        return this.getModelMonitor(request);
    }

    public final ModelMonitor getModelMonitor(GetModelMonitorRequest request) {
        return (ModelMonitor)this.getModelMonitorCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelMonitorRequest, ModelMonitor> getModelMonitorCallable() {
        return this.stub.getModelMonitorCallable();
    }

    public final ListModelMonitorsPagedResponse listModelMonitors(LocationName parent) {
        ListModelMonitorsRequest request = ListModelMonitorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelMonitors(request);
    }

    public final ListModelMonitorsPagedResponse listModelMonitors(String parent) {
        ListModelMonitorsRequest request = ListModelMonitorsRequest.newBuilder().setParent(parent).build();
        return this.listModelMonitors(request);
    }

    public final ListModelMonitorsPagedResponse listModelMonitors(ListModelMonitorsRequest request) {
        return (ListModelMonitorsPagedResponse)((Object)this.listModelMonitorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelMonitorsRequest, ListModelMonitorsPagedResponse> listModelMonitorsPagedCallable() {
        return this.stub.listModelMonitorsPagedCallable();
    }

    public final UnaryCallable<ListModelMonitorsRequest, ListModelMonitorsResponse> listModelMonitorsCallable() {
        return this.stub.listModelMonitorsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitorAsync(ModelMonitorName name) {
        DeleteModelMonitorRequest request = DeleteModelMonitorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelMonitorAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitorAsync(String name) {
        DeleteModelMonitorRequest request = DeleteModelMonitorRequest.newBuilder().setName(name).build();
        return this.deleteModelMonitorAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitorAsync(DeleteModelMonitorRequest request) {
        return this.deleteModelMonitorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelMonitorRequest, Empty, DeleteOperationMetadata> deleteModelMonitorOperationCallable() {
        return this.stub.deleteModelMonitorOperationCallable();
    }

    public final UnaryCallable<DeleteModelMonitorRequest, Operation> deleteModelMonitorCallable() {
        return this.stub.deleteModelMonitorCallable();
    }

    public final ModelMonitoringJob createModelMonitoringJob(ModelMonitorName parent, ModelMonitoringJob modelMonitoringJob) {
        CreateModelMonitoringJobRequest request = CreateModelMonitoringJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModelMonitoringJob(modelMonitoringJob).build();
        return this.createModelMonitoringJob(request);
    }

    public final ModelMonitoringJob createModelMonitoringJob(String parent, ModelMonitoringJob modelMonitoringJob) {
        CreateModelMonitoringJobRequest request = CreateModelMonitoringJobRequest.newBuilder().setParent(parent).setModelMonitoringJob(modelMonitoringJob).build();
        return this.createModelMonitoringJob(request);
    }

    public final ModelMonitoringJob createModelMonitoringJob(CreateModelMonitoringJobRequest request) {
        return (ModelMonitoringJob)this.createModelMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateModelMonitoringJobRequest, ModelMonitoringJob> createModelMonitoringJobCallable() {
        return this.stub.createModelMonitoringJobCallable();
    }

    public final ModelMonitoringJob getModelMonitoringJob(ModelMonitoringJobName name) {
        GetModelMonitoringJobRequest request = GetModelMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelMonitoringJob(request);
    }

    public final ModelMonitoringJob getModelMonitoringJob(String name) {
        GetModelMonitoringJobRequest request = GetModelMonitoringJobRequest.newBuilder().setName(name).build();
        return this.getModelMonitoringJob(request);
    }

    public final ModelMonitoringJob getModelMonitoringJob(GetModelMonitoringJobRequest request) {
        return (ModelMonitoringJob)this.getModelMonitoringJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelMonitoringJobRequest, ModelMonitoringJob> getModelMonitoringJobCallable() {
        return this.stub.getModelMonitoringJobCallable();
    }

    public final ListModelMonitoringJobsPagedResponse listModelMonitoringJobs(ModelMonitorName parent) {
        ListModelMonitoringJobsRequest request = ListModelMonitoringJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelMonitoringJobs(request);
    }

    public final ListModelMonitoringJobsPagedResponse listModelMonitoringJobs(String parent) {
        ListModelMonitoringJobsRequest request = ListModelMonitoringJobsRequest.newBuilder().setParent(parent).build();
        return this.listModelMonitoringJobs(request);
    }

    public final ListModelMonitoringJobsPagedResponse listModelMonitoringJobs(ListModelMonitoringJobsRequest request) {
        return (ListModelMonitoringJobsPagedResponse)((Object)this.listModelMonitoringJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelMonitoringJobsRequest, ListModelMonitoringJobsPagedResponse> listModelMonitoringJobsPagedCallable() {
        return this.stub.listModelMonitoringJobsPagedCallable();
    }

    public final UnaryCallable<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse> listModelMonitoringJobsCallable() {
        return this.stub.listModelMonitoringJobsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitoringJobAsync(ModelMonitoringJobName name) {
        DeleteModelMonitoringJobRequest request = DeleteModelMonitoringJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelMonitoringJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitoringJobAsync(String name) {
        DeleteModelMonitoringJobRequest request = DeleteModelMonitoringJobRequest.newBuilder().setName(name).build();
        return this.deleteModelMonitoringJobAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelMonitoringJobAsync(DeleteModelMonitoringJobRequest request) {
        return this.deleteModelMonitoringJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelMonitoringJobRequest, Empty, DeleteOperationMetadata> deleteModelMonitoringJobOperationCallable() {
        return this.stub.deleteModelMonitoringJobOperationCallable();
    }

    public final UnaryCallable<DeleteModelMonitoringJobRequest, Operation> deleteModelMonitoringJobCallable() {
        return this.stub.deleteModelMonitoringJobCallable();
    }

    public final SearchModelMonitoringStatsPagedResponse searchModelMonitoringStats(ModelMonitorName modelMonitor) {
        SearchModelMonitoringStatsRequest request = SearchModelMonitoringStatsRequest.newBuilder().setModelMonitor(modelMonitor == null ? null : modelMonitor.toString()).build();
        return this.searchModelMonitoringStats(request);
    }

    public final SearchModelMonitoringStatsPagedResponse searchModelMonitoringStats(String modelMonitor) {
        SearchModelMonitoringStatsRequest request = SearchModelMonitoringStatsRequest.newBuilder().setModelMonitor(modelMonitor).build();
        return this.searchModelMonitoringStats(request);
    }

    public final SearchModelMonitoringStatsPagedResponse searchModelMonitoringStats(SearchModelMonitoringStatsRequest request) {
        return (SearchModelMonitoringStatsPagedResponse)((Object)this.searchModelMonitoringStatsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsPagedResponse> searchModelMonitoringStatsPagedCallable() {
        return this.stub.searchModelMonitoringStatsPagedCallable();
    }

    public final UnaryCallable<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse> searchModelMonitoringStatsCallable() {
        return this.stub.searchModelMonitoringStatsCallable();
    }

    public final SearchModelMonitoringAlertsPagedResponse searchModelMonitoringAlerts(ModelMonitorName modelMonitor) {
        SearchModelMonitoringAlertsRequest request = SearchModelMonitoringAlertsRequest.newBuilder().setModelMonitor(modelMonitor == null ? null : modelMonitor.toString()).build();
        return this.searchModelMonitoringAlerts(request);
    }

    public final SearchModelMonitoringAlertsPagedResponse searchModelMonitoringAlerts(String modelMonitor) {
        SearchModelMonitoringAlertsRequest request = SearchModelMonitoringAlertsRequest.newBuilder().setModelMonitor(modelMonitor).build();
        return this.searchModelMonitoringAlerts(request);
    }

    public final SearchModelMonitoringAlertsPagedResponse searchModelMonitoringAlerts(SearchModelMonitoringAlertsRequest request) {
        return (SearchModelMonitoringAlertsPagedResponse)((Object)this.searchModelMonitoringAlertsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsPagedResponse> searchModelMonitoringAlertsPagedCallable() {
        return this.stub.searchModelMonitoringAlertsPagedCallable();
    }

    public final UnaryCallable<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse> searchModelMonitoringAlertsCallable() {
        return this.stub.searchModelMonitoringAlertsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchModelMonitoringAlertsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert, SearchModelMonitoringAlertsPage, SearchModelMonitoringAlertsFixedSizeCollection> {
        private SearchModelMonitoringAlertsFixedSizeCollection(List<SearchModelMonitoringAlertsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchModelMonitoringAlertsFixedSizeCollection createEmptyCollection() {
            return new SearchModelMonitoringAlertsFixedSizeCollection(null, 0);
        }

        protected SearchModelMonitoringAlertsFixedSizeCollection createCollection(List<SearchModelMonitoringAlertsPage> pages, int collectionSize) {
            return new SearchModelMonitoringAlertsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchModelMonitoringAlertsPage
    extends AbstractPage<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert, SearchModelMonitoringAlertsPage> {
        private SearchModelMonitoringAlertsPage(PageContext<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert> context, SearchModelMonitoringAlertsResponse response) {
            super(context, (Object)response);
        }

        private static SearchModelMonitoringAlertsPage createEmptyPage() {
            return new SearchModelMonitoringAlertsPage(null, null);
        }

        protected SearchModelMonitoringAlertsPage createPage(PageContext<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert> context, SearchModelMonitoringAlertsResponse response) {
            return new SearchModelMonitoringAlertsPage(context, response);
        }

        public ApiFuture<SearchModelMonitoringAlertsPage> createPageAsync(PageContext<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert> context, ApiFuture<SearchModelMonitoringAlertsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchModelMonitoringAlertsPagedResponse
    extends AbstractPagedListResponse<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert, SearchModelMonitoringAlertsPage, SearchModelMonitoringAlertsFixedSizeCollection> {
        public static ApiFuture<SearchModelMonitoringAlertsPagedResponse> createAsync(PageContext<SearchModelMonitoringAlertsRequest, SearchModelMonitoringAlertsResponse, ModelMonitoringAlert> context, ApiFuture<SearchModelMonitoringAlertsResponse> futureResponse) {
            ApiFuture<SearchModelMonitoringAlertsPage> futurePage = SearchModelMonitoringAlertsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchModelMonitoringAlertsPagedResponse((SearchModelMonitoringAlertsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchModelMonitoringAlertsPagedResponse(SearchModelMonitoringAlertsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchModelMonitoringAlertsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchModelMonitoringStatsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats, SearchModelMonitoringStatsPage, SearchModelMonitoringStatsFixedSizeCollection> {
        private SearchModelMonitoringStatsFixedSizeCollection(List<SearchModelMonitoringStatsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchModelMonitoringStatsFixedSizeCollection createEmptyCollection() {
            return new SearchModelMonitoringStatsFixedSizeCollection(null, 0);
        }

        protected SearchModelMonitoringStatsFixedSizeCollection createCollection(List<SearchModelMonitoringStatsPage> pages, int collectionSize) {
            return new SearchModelMonitoringStatsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchModelMonitoringStatsPage
    extends AbstractPage<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats, SearchModelMonitoringStatsPage> {
        private SearchModelMonitoringStatsPage(PageContext<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats> context, SearchModelMonitoringStatsResponse response) {
            super(context, (Object)response);
        }

        private static SearchModelMonitoringStatsPage createEmptyPage() {
            return new SearchModelMonitoringStatsPage(null, null);
        }

        protected SearchModelMonitoringStatsPage createPage(PageContext<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats> context, SearchModelMonitoringStatsResponse response) {
            return new SearchModelMonitoringStatsPage(context, response);
        }

        public ApiFuture<SearchModelMonitoringStatsPage> createPageAsync(PageContext<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats> context, ApiFuture<SearchModelMonitoringStatsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchModelMonitoringStatsPagedResponse
    extends AbstractPagedListResponse<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats, SearchModelMonitoringStatsPage, SearchModelMonitoringStatsFixedSizeCollection> {
        public static ApiFuture<SearchModelMonitoringStatsPagedResponse> createAsync(PageContext<SearchModelMonitoringStatsRequest, SearchModelMonitoringStatsResponse, ModelMonitoringStats> context, ApiFuture<SearchModelMonitoringStatsResponse> futureResponse) {
            ApiFuture<SearchModelMonitoringStatsPage> futurePage = SearchModelMonitoringStatsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchModelMonitoringStatsPagedResponse((SearchModelMonitoringStatsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchModelMonitoringStatsPagedResponse(SearchModelMonitoringStatsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchModelMonitoringStatsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelMonitoringJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob, ListModelMonitoringJobsPage, ListModelMonitoringJobsFixedSizeCollection> {
        private ListModelMonitoringJobsFixedSizeCollection(List<ListModelMonitoringJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelMonitoringJobsFixedSizeCollection createEmptyCollection() {
            return new ListModelMonitoringJobsFixedSizeCollection(null, 0);
        }

        protected ListModelMonitoringJobsFixedSizeCollection createCollection(List<ListModelMonitoringJobsPage> pages, int collectionSize) {
            return new ListModelMonitoringJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelMonitoringJobsPage
    extends AbstractPage<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob, ListModelMonitoringJobsPage> {
        private ListModelMonitoringJobsPage(PageContext<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob> context, ListModelMonitoringJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelMonitoringJobsPage createEmptyPage() {
            return new ListModelMonitoringJobsPage(null, null);
        }

        protected ListModelMonitoringJobsPage createPage(PageContext<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob> context, ListModelMonitoringJobsResponse response) {
            return new ListModelMonitoringJobsPage(context, response);
        }

        public ApiFuture<ListModelMonitoringJobsPage> createPageAsync(PageContext<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob> context, ApiFuture<ListModelMonitoringJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelMonitoringJobsPagedResponse
    extends AbstractPagedListResponse<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob, ListModelMonitoringJobsPage, ListModelMonitoringJobsFixedSizeCollection> {
        public static ApiFuture<ListModelMonitoringJobsPagedResponse> createAsync(PageContext<ListModelMonitoringJobsRequest, ListModelMonitoringJobsResponse, ModelMonitoringJob> context, ApiFuture<ListModelMonitoringJobsResponse> futureResponse) {
            ApiFuture<ListModelMonitoringJobsPage> futurePage = ListModelMonitoringJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelMonitoringJobsPagedResponse((ListModelMonitoringJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelMonitoringJobsPagedResponse(ListModelMonitoringJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelMonitoringJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelMonitorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor, ListModelMonitorsPage, ListModelMonitorsFixedSizeCollection> {
        private ListModelMonitorsFixedSizeCollection(List<ListModelMonitorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelMonitorsFixedSizeCollection createEmptyCollection() {
            return new ListModelMonitorsFixedSizeCollection(null, 0);
        }

        protected ListModelMonitorsFixedSizeCollection createCollection(List<ListModelMonitorsPage> pages, int collectionSize) {
            return new ListModelMonitorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelMonitorsPage
    extends AbstractPage<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor, ListModelMonitorsPage> {
        private ListModelMonitorsPage(PageContext<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor> context, ListModelMonitorsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelMonitorsPage createEmptyPage() {
            return new ListModelMonitorsPage(null, null);
        }

        protected ListModelMonitorsPage createPage(PageContext<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor> context, ListModelMonitorsResponse response) {
            return new ListModelMonitorsPage(context, response);
        }

        public ApiFuture<ListModelMonitorsPage> createPageAsync(PageContext<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor> context, ApiFuture<ListModelMonitorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelMonitorsPagedResponse
    extends AbstractPagedListResponse<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor, ListModelMonitorsPage, ListModelMonitorsFixedSizeCollection> {
        public static ApiFuture<ListModelMonitorsPagedResponse> createAsync(PageContext<ListModelMonitorsRequest, ListModelMonitorsResponse, ModelMonitor> context, ApiFuture<ListModelMonitorsResponse> futureResponse) {
            ApiFuture<ListModelMonitorsPage> futurePage = ListModelMonitorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelMonitorsPagedResponse((ListModelMonitorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelMonitorsPagedResponse(ListModelMonitorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelMonitorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

