/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateReasoningEngineOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.GetReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.ListReasoningEnginesRequest;
import com.google.cloud.aiplatform.v1beta1.ListReasoningEnginesResponse;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngine;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngineServiceClient;
import com.google.cloud.aiplatform.v1beta1.UpdateReasoningEngineOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcReasoningEngineServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ReasoningEngineServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ReasoningEngineServiceStubSettings
extends StubSettings<ReasoningEngineServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateReasoningEngineRequest, Operation> createReasoningEngineSettings;
    private final OperationCallSettings<CreateReasoningEngineRequest, ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineOperationSettings;
    private final UnaryCallSettings<GetReasoningEngineRequest, ReasoningEngine> getReasoningEngineSettings;
    private final PagedCallSettings<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> listReasoningEnginesSettings;
    private final UnaryCallSettings<UpdateReasoningEngineRequest, Operation> updateReasoningEngineSettings;
    private final OperationCallSettings<UpdateReasoningEngineRequest, ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineOperationSettings;
    private final UnaryCallSettings<DeleteReasoningEngineRequest, Operation> deleteReasoningEngineSettings;
    private final OperationCallSettings<DeleteReasoningEngineRequest, Empty, DeleteOperationMetadata> deleteReasoningEngineOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine> LIST_REASONING_ENGINES_PAGE_STR_DESC = new PagedListDescriptor<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine>(){

        public String emptyToken() {
            return "";
        }

        public ListReasoningEnginesRequest injectToken(ListReasoningEnginesRequest payload, String token) {
            return ListReasoningEnginesRequest.newBuilder((ListReasoningEnginesRequest)payload).setPageToken(token).build();
        }

        public ListReasoningEnginesRequest injectPageSize(ListReasoningEnginesRequest payload, int pageSize) {
            return ListReasoningEnginesRequest.newBuilder((ListReasoningEnginesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReasoningEnginesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReasoningEnginesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReasoningEngine> extractResources(ListReasoningEnginesResponse payload) {
            return payload.getReasoningEnginesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> LIST_REASONING_ENGINES_PAGE_STR_FACT = new PagedListResponseFactory<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse>(){

        public ApiFuture<ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> getFuturePagedResponse(UnaryCallable<ListReasoningEnginesRequest, ListReasoningEnginesResponse> callable, ListReasoningEnginesRequest request, ApiCallContext context, ApiFuture<ListReasoningEnginesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REASONING_ENGINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse.createAsync((PageContext<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<ReasoningEngineServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReasoningEngineServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateReasoningEngineRequest, Operation> createReasoningEngineSettings() {
        return this.createReasoningEngineSettings;
    }

    public OperationCallSettings<CreateReasoningEngineRequest, ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineOperationSettings() {
        return this.createReasoningEngineOperationSettings;
    }

    public UnaryCallSettings<GetReasoningEngineRequest, ReasoningEngine> getReasoningEngineSettings() {
        return this.getReasoningEngineSettings;
    }

    public PagedCallSettings<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> listReasoningEnginesSettings() {
        return this.listReasoningEnginesSettings;
    }

    public UnaryCallSettings<UpdateReasoningEngineRequest, Operation> updateReasoningEngineSettings() {
        return this.updateReasoningEngineSettings;
    }

    public OperationCallSettings<UpdateReasoningEngineRequest, ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineOperationSettings() {
        return this.updateReasoningEngineOperationSettings;
    }

    public UnaryCallSettings<DeleteReasoningEngineRequest, Operation> deleteReasoningEngineSettings() {
        return this.deleteReasoningEngineSettings;
    }

    public OperationCallSettings<DeleteReasoningEngineRequest, Empty, DeleteOperationMetadata> deleteReasoningEngineOperationSettings() {
        return this.deleteReasoningEngineOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ReasoningEngineServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcReasoningEngineServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReasoningEngineServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReasoningEngineServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReasoningEngineServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createReasoningEngineSettings = settingsBuilder.createReasoningEngineSettings().build();
        this.createReasoningEngineOperationSettings = settingsBuilder.createReasoningEngineOperationSettings().build();
        this.getReasoningEngineSettings = settingsBuilder.getReasoningEngineSettings().build();
        this.listReasoningEnginesSettings = settingsBuilder.listReasoningEnginesSettings().build();
        this.updateReasoningEngineSettings = settingsBuilder.updateReasoningEngineSettings().build();
        this.updateReasoningEngineOperationSettings = settingsBuilder.updateReasoningEngineOperationSettings().build();
        this.deleteReasoningEngineSettings = settingsBuilder.deleteReasoningEngineSettings().build();
        this.deleteReasoningEngineOperationSettings = settingsBuilder.deleteReasoningEngineOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReasoningEngineServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateReasoningEngineRequest, Operation> createReasoningEngineSettings;
        private final OperationCallSettings.Builder<CreateReasoningEngineRequest, ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineOperationSettings;
        private final UnaryCallSettings.Builder<GetReasoningEngineRequest, ReasoningEngine> getReasoningEngineSettings;
        private final PagedCallSettings.Builder<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> listReasoningEnginesSettings;
        private final UnaryCallSettings.Builder<UpdateReasoningEngineRequest, Operation> updateReasoningEngineSettings;
        private final OperationCallSettings.Builder<UpdateReasoningEngineRequest, ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineOperationSettings;
        private final UnaryCallSettings.Builder<DeleteReasoningEngineRequest, Operation> deleteReasoningEngineSettings;
        private final OperationCallSettings.Builder<DeleteReasoningEngineRequest, Empty, DeleteOperationMetadata> deleteReasoningEngineOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createReasoningEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReasoningEngineOperationSettings = OperationCallSettings.newBuilder();
            this.getReasoningEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReasoningEnginesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REASONING_ENGINES_PAGE_STR_FACT);
            this.updateReasoningEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateReasoningEngineOperationSettings = OperationCallSettings.newBuilder();
            this.deleteReasoningEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteReasoningEngineOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReasoningEngineSettings, this.getReasoningEngineSettings, this.listReasoningEnginesSettings, this.updateReasoningEngineSettings, this.deleteReasoningEngineSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReasoningEngineServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createReasoningEngineSettings = settings.createReasoningEngineSettings.toBuilder();
            this.createReasoningEngineOperationSettings = settings.createReasoningEngineOperationSettings.toBuilder();
            this.getReasoningEngineSettings = settings.getReasoningEngineSettings.toBuilder();
            this.listReasoningEnginesSettings = settings.listReasoningEnginesSettings.toBuilder();
            this.updateReasoningEngineSettings = settings.updateReasoningEngineSettings.toBuilder();
            this.updateReasoningEngineOperationSettings = settings.updateReasoningEngineOperationSettings.toBuilder();
            this.deleteReasoningEngineSettings = settings.deleteReasoningEngineSettings.toBuilder();
            this.deleteReasoningEngineOperationSettings = settings.deleteReasoningEngineOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReasoningEngineSettings, this.getReasoningEngineSettings, this.listReasoningEnginesSettings, this.updateReasoningEngineSettings, this.deleteReasoningEngineSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReasoningEngineServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReasoningEngineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReasoningEngineServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReasoningEngineServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createReasoningEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getReasoningEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listReasoningEnginesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateReasoningEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteReasoningEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createReasoningEngineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReasoningEngine.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateReasoningEngineOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateReasoningEngineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReasoningEngine.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateReasoningEngineOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteReasoningEngineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateReasoningEngineRequest, Operation> createReasoningEngineSettings() {
            return this.createReasoningEngineSettings;
        }

        public OperationCallSettings.Builder<CreateReasoningEngineRequest, ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineOperationSettings() {
            return this.createReasoningEngineOperationSettings;
        }

        public UnaryCallSettings.Builder<GetReasoningEngineRequest, ReasoningEngine> getReasoningEngineSettings() {
            return this.getReasoningEngineSettings;
        }

        public PagedCallSettings.Builder<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngineServiceClient.ListReasoningEnginesPagedResponse> listReasoningEnginesSettings() {
            return this.listReasoningEnginesSettings;
        }

        public UnaryCallSettings.Builder<UpdateReasoningEngineRequest, Operation> updateReasoningEngineSettings() {
            return this.updateReasoningEngineSettings;
        }

        public OperationCallSettings.Builder<UpdateReasoningEngineRequest, ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineOperationSettings() {
            return this.updateReasoningEngineOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteReasoningEngineRequest, Operation> deleteReasoningEngineSettings() {
            return this.deleteReasoningEngineSettings;
        }

        public OperationCallSettings.Builder<DeleteReasoningEngineRequest, Empty, DeleteOperationMetadata> deleteReasoningEngineOperationSettings() {
            return this.deleteReasoningEngineOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ReasoningEngineServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ReasoningEngineServiceStubSettings build() throws IOException {
            return new ReasoningEngineServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

