/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.appgateways.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.appgateways.v1.AppGateway;
import com.google.cloud.beyondcorp.appgateways.v1.AppGatewayName;
import com.google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata;
import com.google.cloud.beyondcorp.appgateways.v1.AppGatewaysServiceSettings;
import com.google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest;
import com.google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest;
import com.google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysResponse;
import com.google.cloud.beyondcorp.appgateways.v1.LocationName;
import com.google.cloud.beyondcorp.appgateways.v1.stub.AppGatewaysServiceStub;
import com.google.cloud.beyondcorp.appgateways.v1.stub.AppGatewaysServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AppGatewaysServiceClient
implements BackgroundResource {
    private final AppGatewaysServiceSettings settings;
    private final AppGatewaysServiceStub stub;
    private final OperationsClient operationsClient;

    public static final AppGatewaysServiceClient create() throws IOException {
        return AppGatewaysServiceClient.create(AppGatewaysServiceSettings.newBuilder().build());
    }

    public static final AppGatewaysServiceClient create(AppGatewaysServiceSettings settings) throws IOException {
        return new AppGatewaysServiceClient(settings);
    }

    public static final AppGatewaysServiceClient create(AppGatewaysServiceStub stub) {
        return new AppGatewaysServiceClient(stub);
    }

    protected AppGatewaysServiceClient(AppGatewaysServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AppGatewaysServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected AppGatewaysServiceClient(AppGatewaysServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AppGatewaysServiceSettings getSettings() {
        return this.settings;
    }

    public AppGatewaysServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAppGatewaysPagedResponse listAppGateways(LocationName parent) {
        ListAppGatewaysRequest request = ListAppGatewaysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAppGateways(request);
    }

    public final ListAppGatewaysPagedResponse listAppGateways(String parent) {
        ListAppGatewaysRequest request = ListAppGatewaysRequest.newBuilder().setParent(parent).build();
        return this.listAppGateways(request);
    }

    public final ListAppGatewaysPagedResponse listAppGateways(ListAppGatewaysRequest request) {
        return (ListAppGatewaysPagedResponse)((Object)this.listAppGatewaysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAppGatewaysRequest, ListAppGatewaysPagedResponse> listAppGatewaysPagedCallable() {
        return this.stub.listAppGatewaysPagedCallable();
    }

    public final UnaryCallable<ListAppGatewaysRequest, ListAppGatewaysResponse> listAppGatewaysCallable() {
        return this.stub.listAppGatewaysCallable();
    }

    public final AppGateway getAppGateway(AppGatewayName name) {
        GetAppGatewayRequest request = GetAppGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAppGateway(request);
    }

    public final AppGateway getAppGateway(String name) {
        GetAppGatewayRequest request = GetAppGatewayRequest.newBuilder().setName(name).build();
        return this.getAppGateway(request);
    }

    public final AppGateway getAppGateway(GetAppGatewayRequest request) {
        return (AppGateway)this.getAppGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<GetAppGatewayRequest, AppGateway> getAppGatewayCallable() {
        return this.stub.getAppGatewayCallable();
    }

    public final OperationFuture<AppGateway, AppGatewayOperationMetadata> createAppGatewayAsync(LocationName parent, AppGateway appGateway, String appGatewayId) {
        CreateAppGatewayRequest request = CreateAppGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAppGateway(appGateway).setAppGatewayId(appGatewayId).build();
        return this.createAppGatewayAsync(request);
    }

    public final OperationFuture<AppGateway, AppGatewayOperationMetadata> createAppGatewayAsync(String parent, AppGateway appGateway, String appGatewayId) {
        CreateAppGatewayRequest request = CreateAppGatewayRequest.newBuilder().setParent(parent).setAppGateway(appGateway).setAppGatewayId(appGatewayId).build();
        return this.createAppGatewayAsync(request);
    }

    public final OperationFuture<AppGateway, AppGatewayOperationMetadata> createAppGatewayAsync(CreateAppGatewayRequest request) {
        return this.createAppGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAppGatewayRequest, AppGateway, AppGatewayOperationMetadata> createAppGatewayOperationCallable() {
        return this.stub.createAppGatewayOperationCallable();
    }

    public final UnaryCallable<CreateAppGatewayRequest, Operation> createAppGatewayCallable() {
        return this.stub.createAppGatewayCallable();
    }

    public final OperationFuture<Empty, AppGatewayOperationMetadata> deleteAppGatewayAsync(AppGatewayName name) {
        DeleteAppGatewayRequest request = DeleteAppGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAppGatewayAsync(request);
    }

    public final OperationFuture<Empty, AppGatewayOperationMetadata> deleteAppGatewayAsync(String name) {
        DeleteAppGatewayRequest request = DeleteAppGatewayRequest.newBuilder().setName(name).build();
        return this.deleteAppGatewayAsync(request);
    }

    public final OperationFuture<Empty, AppGatewayOperationMetadata> deleteAppGatewayAsync(DeleteAppGatewayRequest request) {
        return this.deleteAppGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAppGatewayRequest, Empty, AppGatewayOperationMetadata> deleteAppGatewayOperationCallable() {
        return this.stub.deleteAppGatewayOperationCallable();
    }

    public final UnaryCallable<DeleteAppGatewayRequest, Operation> deleteAppGatewayCallable() {
        return this.stub.deleteAppGatewayCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAppGatewaysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway, ListAppGatewaysPage, ListAppGatewaysFixedSizeCollection> {
        private ListAppGatewaysFixedSizeCollection(List<ListAppGatewaysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAppGatewaysFixedSizeCollection createEmptyCollection() {
            return new ListAppGatewaysFixedSizeCollection(null, 0);
        }

        protected ListAppGatewaysFixedSizeCollection createCollection(List<ListAppGatewaysPage> pages, int collectionSize) {
            return new ListAppGatewaysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAppGatewaysPage
    extends AbstractPage<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway, ListAppGatewaysPage> {
        private ListAppGatewaysPage(PageContext<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway> context, ListAppGatewaysResponse response) {
            super(context, (Object)response);
        }

        private static ListAppGatewaysPage createEmptyPage() {
            return new ListAppGatewaysPage(null, null);
        }

        protected ListAppGatewaysPage createPage(PageContext<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway> context, ListAppGatewaysResponse response) {
            return new ListAppGatewaysPage(context, response);
        }

        public ApiFuture<ListAppGatewaysPage> createPageAsync(PageContext<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway> context, ApiFuture<ListAppGatewaysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAppGatewaysPagedResponse
    extends AbstractPagedListResponse<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway, ListAppGatewaysPage, ListAppGatewaysFixedSizeCollection> {
        public static ApiFuture<ListAppGatewaysPagedResponse> createAsync(PageContext<ListAppGatewaysRequest, ListAppGatewaysResponse, AppGateway> context, ApiFuture<ListAppGatewaysResponse> futureResponse) {
            ApiFuture<ListAppGatewaysPage> futurePage = ListAppGatewaysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAppGatewaysPagedResponse((ListAppGatewaysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAppGatewaysPagedResponse(ListAppGatewaysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAppGatewaysFixedSizeCollection.createEmptyCollection());
        }
    }
}

