package com.google.cloud.bigquery;

import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RemoteFunctionOptions extends RemoteFunctionOptions {

  @Nullable
  private final String endpoint;

  @Nullable
  private final String connection;

  @Nullable
  private final Map<String, String> userDefinedContext;

  @Nullable
  private final Long maxBatchingRows;

  private AutoValue_RemoteFunctionOptions(
      @Nullable String endpoint,
      @Nullable String connection,
      @Nullable Map<String, String> userDefinedContext,
      @Nullable Long maxBatchingRows) {
    this.endpoint = endpoint;
    this.connection = connection;
    this.userDefinedContext = userDefinedContext;
    this.maxBatchingRows = maxBatchingRows;
  }

  @Nullable
  @Override
  public String getEndpoint() {
    return endpoint;
  }

  @Nullable
  @Override
  public String getConnection() {
    return connection;
  }

  @Nullable
  @Override
  public Map<String, String> getUserDefinedContext() {
    return userDefinedContext;
  }

  @Nullable
  @Override
  public Long getMaxBatchingRows() {
    return maxBatchingRows;
  }

  @Override
  public String toString() {
    return "RemoteFunctionOptions{"
        + "endpoint=" + endpoint + ", "
        + "connection=" + connection + ", "
        + "userDefinedContext=" + userDefinedContext + ", "
        + "maxBatchingRows=" + maxBatchingRows
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RemoteFunctionOptions) {
      RemoteFunctionOptions that = (RemoteFunctionOptions) o;
      return (this.endpoint == null ? that.getEndpoint() == null : this.endpoint.equals(that.getEndpoint()))
          && (this.connection == null ? that.getConnection() == null : this.connection.equals(that.getConnection()))
          && (this.userDefinedContext == null ? that.getUserDefinedContext() == null : this.userDefinedContext.equals(that.getUserDefinedContext()))
          && (this.maxBatchingRows == null ? that.getMaxBatchingRows() == null : this.maxBatchingRows.equals(that.getMaxBatchingRows()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (endpoint == null) ? 0 : endpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (connection == null) ? 0 : connection.hashCode();
    h$ *= 1000003;
    h$ ^= (userDefinedContext == null) ? 0 : userDefinedContext.hashCode();
    h$ *= 1000003;
    h$ ^= (maxBatchingRows == null) ? 0 : maxBatchingRows.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -7334249450657429792L;

  @Override
  public RemoteFunctionOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends RemoteFunctionOptions.Builder {
    private String endpoint;
    private String connection;
    private Map<String, String> userDefinedContext;
    private Long maxBatchingRows;
    Builder() {
    }
    private Builder(RemoteFunctionOptions source) {
      this.endpoint = source.getEndpoint();
      this.connection = source.getConnection();
      this.userDefinedContext = source.getUserDefinedContext();
      this.maxBatchingRows = source.getMaxBatchingRows();
    }
    @Override
    public RemoteFunctionOptions.Builder setEndpoint(String endpoint) {
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public RemoteFunctionOptions.Builder setConnection(String connection) {
      this.connection = connection;
      return this;
    }
    @Override
    public RemoteFunctionOptions.Builder setUserDefinedContext(Map<String, String> userDefinedContext) {
      this.userDefinedContext = userDefinedContext;
      return this;
    }
    @Override
    public RemoteFunctionOptions.Builder setMaxBatchingRows(Long maxBatchingRows) {
      this.maxBatchingRows = maxBatchingRows;
      return this;
    }
    @Override
    public RemoteFunctionOptions build() {
      return new AutoValue_RemoteFunctionOptions(
          this.endpoint,
          this.connection,
          this.userDefinedContext,
          this.maxBatchingRows);
    }
  }

}
