package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Parameter extends Parameter {

  @Nullable
  private final String name;

  private final QueryParameterValue value;

  private AutoValue_Parameter(
      @Nullable String name,
      QueryParameterValue value) {
    this.name = name;
    this.value = value;
  }

  @Nullable
  @Override
  public String getName() {
    return name;
  }

  @Override
  public QueryParameterValue getValue() {
    return value;
  }

  @Override
  public String toString() {
    return "Parameter{"
        + "name=" + name + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Parameter) {
      Parameter that = (Parameter) o;
      return (this.name == null ? that.getName() == null : this.name.equals(that.getName()))
          && this.value.equals(that.getValue());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (name == null) ? 0 : name.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  @Override
  public Parameter.Builder toBuilder() {
    return new AutoValue_Parameter.Builder(this);
  }

  static final class Builder extends Parameter.Builder {
    private String name;
    private QueryParameterValue value;
    Builder() {
    }
    Builder(Parameter source) {
      this.name = source.getName();
      this.value = source.getValue();
    }
    @Override
    public Parameter.Builder setName(String name) {
      this.name = name;
      return this;
    }
    @Override
    public Parameter.Builder setValue(QueryParameterValue value) {
      if (value == null) {
        throw new NullPointerException("Null value");
      }
      this.value = value;
      return this;
    }
    @Override
    public Parameter build() {
      if (this.value == null) {
        String missing = " value";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Parameter(
          this.name,
          this.value);
    }
  }

}
