/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.MonitoredResource;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.IntervalMetricReader;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricReader;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.Metrics;
import com.google.cloud.bigtable.stats.BigtableCreateTimeSeriesExporter;
import com.google.cloud.bigtable.stats.ConsumerEnvironmentUtils;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;

@InternalApi
public class BigtableStackdriverStatsExporter {
    static final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private static BigtableStackdriverStatsExporter instance = null;
    private static final com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration EXPORT_INTERVAL = com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration.create(60L, 0);
    private static final String MONITORING_ENDPOINT = (String)MoreObjects.firstNonNull((Object)System.getProperty("bigtable.test-monitoring-endpoint"), (Object)MetricServiceSettings.getDefaultEndpoint());
    private final IntervalMetricReader intervalMetricReader;

    private BigtableStackdriverStatsExporter(MetricServiceClient metricServiceClient, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration exportInterval, MonitoredResource gceOrGkeMonitoredResource) {
        IntervalMetricReader.Options.Builder intervalMetricReaderOptionsBuilder = IntervalMetricReader.Options.builder();
        intervalMetricReaderOptionsBuilder.setExportInterval(exportInterval);
        this.intervalMetricReader = IntervalMetricReader.create(new BigtableCreateTimeSeriesExporter(metricServiceClient, gceOrGkeMonitoredResource), MetricReader.create(MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).build()), intervalMetricReaderOptionsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Credentials credentials) throws IOException {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Bigtable Stackdriver stats exporter is already created");
            MetricServiceClient client = BigtableStackdriverStatsExporter.createMetricServiceClient(credentials, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration.create(60L, 0));
            MonitoredResource gceOrGkeMonitoredResource = null;
            if (ConsumerEnvironmentUtils.isEnvGce() || ConsumerEnvironmentUtils.isEnvGke()) {
                gceOrGkeMonitoredResource = StackdriverStatsConfiguration.builder().build().getMonitoredResource();
            }
            instance = new BigtableStackdriverStatsExporter(client, EXPORT_INTERVAL, gceOrGkeMonitoredResource);
        }
    }

    @GuardedBy(value="lock")
    @VisibleForTesting
    static MetricServiceClient createMetricServiceClient(Credentials credentials, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration deadline) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().build());
        settingsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials));
        settingsBuilder.setEndpoint(MONITORING_ENDPOINT);
        Duration timeout = Duration.ofMillis((long)deadline.toMillis());
        settingsBuilder.createServiceTimeSeriesSettings().setSimpleTimeoutNoRetries(timeout);
        return MetricServiceClient.create((MetricServiceSettings)settingsBuilder.build());
    }
}

