/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.View;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagKey;
import com.google.cloud.bigtable.stats.BuiltinViewConstants;
import com.google.cloud.bigtable.stats.BuiltinViews;
import com.google.cloud.bigtable.stats.StatsRecorderWrapper;
import com.google.cloud.bigtable.stats.StatsRecorderWrapperForConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@InternalApi(value="For internal use only")
public class StatsWrapper {
    public static StatsRecorderWrapper createRecorder(ApiTracerFactory.OperationType operationType, SpanName spanName, Map<String, String> statsAttributes) {
        return new StatsRecorderWrapper(operationType, spanName, statsAttributes, Stats.getStatsRecorder());
    }

    public static StatsRecorderWrapperForConnection createRecorderForConnection(Map<String, String> statsAttributes) {
        return new StatsRecorderWrapperForConnection(statsAttributes, Stats.getStatsRecorder());
    }

    @InternalApi(value="Visible for testing")
    public static List<String> getOperationLatencyViewTagValueStrings() {
        return Stats.getViewManager().getView(BuiltinViewConstants.OPERATION_LATENCIES_VIEW.getName()).getAggregationMap().entrySet().stream().map(Map.Entry::getKey).flatMap(x -> x.stream()).map(x -> x.asString()).collect(Collectors.toCollection(ArrayList::new));
    }

    static Map<String, List<String>> getBigtableViewToTagMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (View view : BuiltinViews.BIGTABLE_BUILTIN_VIEWS) {
            List<TagKey> tagKeys = view.getColumns();
            map.put(view.getName().asString(), tagKeys.stream().map(tagKey -> tagKey.getName()).collect(Collectors.toList()));
        }
        return map;
    }
}

