/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ClientContext;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import java.io.IOException;
import javax.annotation.Nonnull;

@BetaApi(value="This feature is currently experimental and can change in the future")
public final class BigtableDataClientFactory
implements AutoCloseable {
    private final BigtableDataSettings defaultSettings;
    private final ClientContext sharedClientContext;

    public static BigtableDataClientFactory create(BigtableDataSettings defaultSettings) throws IOException {
        ClientContext sharedClientContext = EnhancedBigtableStub.createClientContext(defaultSettings.getStubSettings());
        return new BigtableDataClientFactory(sharedClientContext, defaultSettings);
    }

    private BigtableDataClientFactory(ClientContext sharedClientContext, BigtableDataSettings defaultSettings) {
        this.sharedClientContext = sharedClientContext;
        this.defaultSettings = defaultSettings;
    }

    @Override
    public void close() throws Exception {
        for (BackgroundResource resource : this.sharedClientContext.getBackgroundResources()) {
            resource.close();
        }
    }

    public BigtableDataClient createDefault() {
        try {
            ClientContext clientContext = this.sharedClientContext.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(this.defaultSettings.getStubSettings())).build();
            return BigtableDataClient.createWithClientContext(this.defaultSettings, clientContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a new client using factory default settings and shared resources.");
        }
    }

    public BigtableDataClient createForAppProfile(@Nonnull String appProfileId) throws IOException {
        BigtableDataSettings settings = this.defaultSettings.toBuilder().setAppProfileId(appProfileId).build();
        ClientContext clientContext = this.sharedClientContext.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(settings.getStubSettings())).build();
        return BigtableDataClient.createWithClientContext(settings, clientContext);
    }

    public BigtableDataClient createForInstance(@Nonnull String projectId, @Nonnull String instanceId) throws IOException {
        BigtableDataSettings settings = this.defaultSettings.toBuilder().setProjectId(projectId).setInstanceId(instanceId).setDefaultAppProfileId().build();
        ClientContext clientContext = this.sharedClientContext.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(settings.getStubSettings())).build();
        return BigtableDataClient.createWithClientContext(settings, clientContext);
    }

    public BigtableDataClient createForInstance(@Nonnull String projectId, @Nonnull String instanceId, @Nonnull String appProfileId) throws IOException {
        BigtableDataSettings settings = this.defaultSettings.toBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId).build();
        ClientContext clientContext = this.sharedClientContext.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(settings.getStubSettings())).build();
        return BigtableDataClient.createWithClientContext(settings, clientContext);
    }
}

