/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RestoreTableRequest {
    private final RestoreTableRequest.Builder requestBuilder = com.google.bigtable.admin.v2.RestoreTableRequest.newBuilder();
    private final String sourceBackupId;
    private final String sourceClusterId;
    private final String sourceInstanceId;
    private final String sourceProjectId;

    public static RestoreTableRequest of(String sourceClusterId, String sourceBackupId) {
        RestoreTableRequest request = new RestoreTableRequest(null, sourceClusterId, sourceBackupId, null);
        return request;
    }

    public static RestoreTableRequest of(String sourceInstanceId, String sourceClusterId, String sourceBackupId) {
        RestoreTableRequest request = new RestoreTableRequest(sourceInstanceId, sourceClusterId, sourceBackupId, null);
        return request;
    }

    public static RestoreTableRequest of(String sourceInstanceId, String sourceClusterId, String sourceBackupId, String sourceProjectId) {
        RestoreTableRequest request = new RestoreTableRequest(sourceInstanceId, sourceClusterId, sourceBackupId, sourceProjectId);
        return request;
    }

    private RestoreTableRequest(@Nullable String sourceInstanceId, @Nonnull String sourceClusterId, @Nonnull String sourceBackupId, @Nullable String sourceProjectId) {
        Preconditions.checkNotNull((Object)sourceClusterId);
        Preconditions.checkNotNull((Object)sourceBackupId);
        this.sourceBackupId = sourceBackupId;
        this.sourceInstanceId = sourceInstanceId;
        this.sourceClusterId = sourceClusterId;
        this.sourceProjectId = sourceProjectId;
    }

    public RestoreTableRequest setTableId(String tableId) {
        Preconditions.checkNotNull((Object)tableId);
        this.requestBuilder.setTableId(tableId);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreTableRequest that = (RestoreTableRequest)o;
        return Objects.equal((Object)this.requestBuilder.getTableId(), (Object)that.requestBuilder.getTableId()) && Objects.equal((Object)this.sourceInstanceId, (Object)that.sourceInstanceId) && Objects.equal((Object)this.sourceClusterId, (Object)that.sourceClusterId) && Objects.equal((Object)this.sourceBackupId, (Object)that.sourceBackupId) && Objects.equal((Object)this.sourceProjectId, (Object)that.sourceProjectId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getTableId(), this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId, this.sourceProjectId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.RestoreTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).setBackup(NameUtil.formatBackupName(this.sourceProjectId == null ? projectId : this.sourceProjectId, this.sourceInstanceId == null ? instanceId : this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId)).build();
    }
}

