/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import java.util.function.Function;

class TransformingServerStreamingCallable<OuterReqT, OuterRespT, InnerReqT, InnerRespT>
extends ServerStreamingCallable<OuterReqT, OuterRespT> {
    private final ServerStreamingCallable<InnerReqT, InnerRespT> inner;
    private final Function<OuterReqT, InnerReqT> requestTransformer;
    private final Function<InnerRespT, OuterRespT> responseTransformer;

    public TransformingServerStreamingCallable(ServerStreamingCallable<InnerReqT, InnerRespT> inner, Function<OuterReqT, InnerReqT> requestTransformer, Function<InnerRespT, OuterRespT> responseTransformer) {
        this.inner = inner;
        this.requestTransformer = requestTransformer;
        this.responseTransformer = responseTransformer;
    }

    public void call(OuterReqT outerReqT, final ResponseObserver<OuterRespT> outerObserver, ApiCallContext apiCallContext) {
        InnerReqT innerReq = this.requestTransformer.apply(outerReqT);
        this.inner.call(innerReq, (ResponseObserver)new SafeResponseObserver<InnerRespT>(outerObserver){

            @Override
            public void onStartImpl(StreamController streamController) {
                outerObserver.onStart(streamController);
            }

            @Override
            public void onResponseImpl(InnerRespT innerResp) {
                outerObserver.onResponse(TransformingServerStreamingCallable.this.responseTransformer.apply(innerResp));
            }

            @Override
            public void onErrorImpl(Throwable throwable) {
                outerObserver.onError(throwable);
            }

            @Override
            public void onCompleteImpl() {
                outerObserver.onComplete();
            }
        }, apiCallContext);
    }
}

