/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.PrepareQueryRequest;
import com.google.bigtable.v2.PrepareQueryResponse;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.stub.BigtableStub;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.GrpcBigtableCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@InternalApi
public class GrpcBigtableStub
extends BigtableStub {
    private static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/ReadRows").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/SampleRowKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)SampleRowKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SampleRowKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowRequest, MutateRowResponse> mutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/MutateRow").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowsRequest, MutateRowsResponse> mutateRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/MutateRows").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/CheckAndMutateRow").setRequestMarshaller(ProtoUtils.marshaller((Message)CheckAndMutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CheckAndMutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/PingAndWarm").setRequestMarshaller(ProtoUtils.marshaller((Message)PingAndWarmRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PingAndWarmResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/ReadModifyWriteRow").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadModifyWriteRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadModifyWriteRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/GenerateInitialChangeStreamPartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateInitialChangeStreamPartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateInitialChangeStreamPartitionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/ReadChangeStream").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadChangeStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadChangeStreamResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PrepareQueryRequest, PrepareQueryResponse> prepareQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/PrepareQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)PrepareQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PrepareQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExecuteQueryRequest, ExecuteQueryResponse> executeQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/ExecuteQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)ExecuteQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ExecuteQueryResponse.getDefaultInstance())).build();
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable;
    private final ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable;
    private final UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable;
    private final UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable;
    private final UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable;
    private final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable;
    private final ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsCallable;
    private final ServerStreamingCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamCallable;
    private final UnaryCallable<PrepareQueryRequest, PrepareQueryResponse> prepareQueryCallable;
    private final ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> executeQueryCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate READ_ROWS_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate READ_ROWS_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate READ_ROWS_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate SAMPLE_ROW_KEYS_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate SAMPLE_ROW_KEYS_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate SAMPLE_ROW_KEYS_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate MUTATE_ROW_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate MUTATE_ROW_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate MUTATE_ROW_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate MUTATE_ROWS_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate MUTATE_ROWS_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate MUTATE_ROWS_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate CHECK_AND_MUTATE_ROW_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate CHECK_AND_MUTATE_ROW_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate CHECK_AND_MUTATE_ROW_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate PING_AND_WARM_0_PATH_TEMPLATE = PathTemplate.create((String)"{name=projects/*/instances/*}");
    private static final PathTemplate PING_AND_WARM_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate READ_MODIFY_WRITE_ROW_0_PATH_TEMPLATE = PathTemplate.create((String)"{table_name=projects/*/instances/*/tables/*}");
    private static final PathTemplate READ_MODIFY_WRITE_ROW_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate READ_MODIFY_WRITE_ROW_2_PATH_TEMPLATE = PathTemplate.create((String)"{authorized_view_name=projects/*/instances/*/tables/*/authorizedViews/*}");
    private static final PathTemplate PREPARE_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{name=projects/*/instances/*}");
    private static final PathTemplate PREPARE_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");
    private static final PathTemplate EXECUTE_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{name=projects/*/instances/*}");
    private static final PathTemplate EXECUTE_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{app_profile_id=**}");

    public static final GrpcBigtableStub create(BigtableStubSettings settings) throws IOException {
        return new GrpcBigtableStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigtableStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigtableStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigtableCallableFactory());
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", READ_ROWS_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", READ_ROWS_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", READ_ROWS_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings sampleRowKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sampleRowKeysMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", SAMPLE_ROW_KEYS_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", SAMPLE_ROW_KEYS_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", SAMPLE_ROW_KEYS_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings mutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", MUTATE_ROW_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", MUTATE_ROW_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", MUTATE_ROW_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings mutateRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", MUTATE_ROWS_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", MUTATE_ROWS_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", MUTATE_ROWS_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings checkAndMutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkAndMutateRowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", CHECK_AND_MUTATE_ROW_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", CHECK_AND_MUTATE_ROW_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", CHECK_AND_MUTATE_ROW_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings pingAndWarmTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pingAndWarmMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "name", PING_AND_WARM_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", PING_AND_WARM_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings readModifyWriteRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readModifyWriteRowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getTableName(), "table_name", READ_MODIFY_WRITE_ROW_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", READ_MODIFY_WRITE_ROW_1_PATH_TEMPLATE);
            builder.add(request.getAuthorizedViewName(), "authorized_view_name", READ_MODIFY_WRITE_ROW_2_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings generateInitialChangeStreamPartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateInitialChangeStreamPartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("table_name", String.valueOf(request.getTableName()));
            return builder.build();
        }).build();
        GrpcCallSettings readChangeStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readChangeStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("table_name", String.valueOf(request.getTableName()));
            return builder.build();
        }).build();
        GrpcCallSettings prepareQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(prepareQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getInstanceName(), "name", PREPARE_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", PREPARE_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings executeQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(executeQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getInstanceName(), "name", EXECUTE_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getAppProfileId(), "app_profile_id", EXECUTE_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.sampleRowKeysCallable = callableFactory.createServerStreamingCallable(sampleRowKeysTransportSettings, settings.sampleRowKeysSettings(), clientContext);
        this.mutateRowCallable = callableFactory.createUnaryCallable(mutateRowTransportSettings, settings.mutateRowSettings(), clientContext);
        this.mutateRowsCallable = callableFactory.createServerStreamingCallable(mutateRowsTransportSettings, settings.mutateRowsSettings(), clientContext);
        this.checkAndMutateRowCallable = callableFactory.createUnaryCallable(checkAndMutateRowTransportSettings, settings.checkAndMutateRowSettings(), clientContext);
        this.pingAndWarmCallable = callableFactory.createUnaryCallable(pingAndWarmTransportSettings, settings.pingAndWarmSettings(), clientContext);
        this.readModifyWriteRowCallable = callableFactory.createUnaryCallable(readModifyWriteRowTransportSettings, settings.readModifyWriteRowSettings(), clientContext);
        this.generateInitialChangeStreamPartitionsCallable = callableFactory.createServerStreamingCallable(generateInitialChangeStreamPartitionsTransportSettings, settings.generateInitialChangeStreamPartitionsSettings(), clientContext);
        this.readChangeStreamCallable = callableFactory.createServerStreamingCallable(readChangeStreamTransportSettings, settings.readChangeStreamSettings(), clientContext);
        this.prepareQueryCallable = callableFactory.createUnaryCallable(prepareQueryTransportSettings, settings.prepareQuerySettings(), clientContext);
        this.executeQueryCallable = callableFactory.createServerStreamingCallable(executeQueryTransportSettings, settings.executeQuerySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    @Override
    public UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    @Override
    public ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable() {
        return this.mutateRowsCallable;
    }

    @Override
    public UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    @Override
    public UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable() {
        return this.pingAndWarmCallable;
    }

    @Override
    public UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    @Override
    public ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> generateInitialChangeStreamPartitionsCallable() {
        return this.generateInitialChangeStreamPartitionsCallable;
    }

    @Override
    public ServerStreamingCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> readChangeStreamCallable() {
        return this.readChangeStreamCallable;
    }

    @Override
    public UnaryCallable<PrepareQueryRequest, PrepareQueryResponse> prepareQueryCallable() {
        return this.prepareQueryCallable;
    }

    @Override
    public ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> executeQueryCallable() {
        return this.executeQueryCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

