/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.Value;
import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public final class Blob
implements Serializable {
    private static final long serialVersionUID = 7311366042557240313L;
    private final ByteString byteString;

    Blob(ByteString byteString) {
        this.byteString = (ByteString)Preconditions.checkNotNull((Object)byteString);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        StringBuilder stBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(256, this.byteString.size()); ++i) {
            stBuilder.append(String.format("%02x", this.byteString.byteAt(i)));
        }
        if (this.byteString.size() > 256) {
            stBuilder.append("...");
        }
        return toStringHelper.add("bytes", (Object)stBuilder.toString()).toString();
    }

    public int hashCode() {
        return this.byteString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Blob && this.byteString.equals((Object)((Blob)obj).byteString);
    }

    public int getLength() {
        return this.byteString.size();
    }

    public byte[] toByteArray() {
        return this.byteString.toByteArray();
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        return this.byteString.asReadOnlyByteBuffer();
    }

    public InputStream asInputStream() {
        final ByteBuffer byteBuffer = this.asReadOnlyByteBuffer();
        return new InputStream(){

            @Override
            public int read() {
                return !byteBuffer.hasRemaining() ? -1 : byteBuffer.get() & 0xFF;
            }
        };
    }

    public void copyTo(ByteBuffer target) {
        this.byteString.copyTo(target);
    }

    public void copyTo(byte[] target) {
        this.byteString.copyTo(target, 0);
    }

    ByteString getByteString() {
        return this.byteString;
    }

    public static Blob copyFrom(byte[] bytes) {
        return new Blob(ByteString.copyFrom((byte[])bytes));
    }

    public static Blob copyFrom(ByteBuffer bytes) {
        return new Blob(ByteString.copyFrom((ByteBuffer)bytes));
    }

    public static Blob copyFrom(InputStream input) throws IOException {
        int value;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((value = bufferedInput.read()) != -1) {
            bytes.write(value);
        }
        return Blob.copyFrom(bytes.toByteArray());
    }

    Value toPb() {
        return Value.newBuilder().setBlobValue(this.byteString).build();
    }
}

