/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.AggregationQuery;
import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.BaseDatastoreBatchWriter;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreHelper;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.ReadOptionProtoPreparer;
import com.google.cloud.datastore.Transaction;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.MutationResult;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.TransactionOptions;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

final class TransactionImpl
extends BaseDatastoreBatchWriter
implements Transaction {
    private final DatastoreImpl datastore;
    private final ByteString transactionId;
    private boolean rolledback;
    private final ReadOptionProtoPreparer readOptionProtoPreparer;

    TransactionImpl(DatastoreImpl datastore) {
        this(datastore, null);
    }

    TransactionImpl(DatastoreImpl datastore, TransactionOptions options) {
        super("transaction");
        this.datastore = datastore;
        BeginTransactionRequest.Builder requestPb = BeginTransactionRequest.newBuilder();
        requestPb.setProjectId(((DatastoreOptions)this.datastore.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.datastore.getOptions()).getDatabaseId());
        if (options != null) {
            requestPb.setTransactionOptions(options);
        }
        this.transactionId = datastore.requestTransactionId(requestPb);
        this.readOptionProtoPreparer = new ReadOptionProtoPreparer();
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        this.validateActive();
        Optional<ReadOptions> readOptions = this.readOptionProtoPreparer.prepare((List<ReadOption>)ImmutableList.of((Object)ReadOption.transactionId(this.transactionId)));
        return this.datastore.get(readOptions, keys);
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        this.validateActive();
        return DatastoreHelper.fetch(this, keys);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        this.validateActive();
        Optional<ReadOptions> readOptions = this.readOptionProtoPreparer.prepare((List<ReadOption>)ImmutableList.of((Object)ReadOption.transactionId(this.transactionId)));
        return this.datastore.run(readOptions, query);
    }

    @Override
    public AggregationResults runAggregation(AggregationQuery query) {
        return this.datastore.runAggregation(query, ReadOption.transactionId(this.transactionId));
    }

    @Override
    public Transaction.Response commit() {
        this.validateActive();
        List<Mutation> mutationsPb = this.toMutationPbList();
        CommitRequest.Builder requestPb = CommitRequest.newBuilder();
        requestPb.setMode(CommitRequest.Mode.TRANSACTIONAL);
        requestPb.setTransaction(this.transactionId);
        requestPb.addAllMutations(mutationsPb);
        requestPb.setProjectId(((DatastoreOptions)this.datastore.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.datastore.getOptions()).getDatabaseId());
        CommitResponse responsePb = this.datastore.commit(requestPb.build());
        this.deactivate();
        return new ResponseImpl(responsePb, this.toAddAutoId().size());
    }

    @Override
    public void rollback() {
        if (this.rolledback) {
            return;
        }
        this.validateActive();
        this.datastore.rollbackTransaction(this.transactionId);
        this.deactivate();
        this.rolledback = true;
    }

    @Override
    public Datastore getDatastore() {
        return this.datastore;
    }

    @Override
    public ByteString getTransactionId() {
        return this.transactionId;
    }

    static class ResponseImpl
    implements Transaction.Response {
        private final CommitResponse response;
        private final int numAutoAllocatedIds;

        ResponseImpl(CommitResponse response, int numAutoAllocatedIds) {
            this.response = response;
            this.numAutoAllocatedIds = numAutoAllocatedIds;
        }

        @Override
        public List<Key> getGeneratedKeys() {
            Iterator results = this.response.getMutationResultsList().iterator();
            ArrayList<Key> generated = new ArrayList<Key>(this.numAutoAllocatedIds);
            for (int i = 0; i < this.numAutoAllocatedIds; ++i) {
                generated.add(Key.fromPb(((MutationResult)results.next()).getKey()));
            }
            return generated;
        }
    }
}

