/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.execution;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.AggregationQuery;
import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.execution.QueryExecutor;
import com.google.cloud.datastore.execution.request.AggregationQueryRequestProtoPreparer;
import com.google.cloud.datastore.execution.response.AggregationQueryResponseTransformer;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import java.util.Arrays;

@InternalApi
public class AggregationQueryExecutor
implements QueryExecutor<AggregationQuery, AggregationResults> {
    private final DatastoreRpc datastoreRpc;
    private final AggregationQueryRequestProtoPreparer protoPreparer;
    private final AggregationQueryResponseTransformer responseTransformer;

    public AggregationQueryExecutor(DatastoreRpc datastoreRpc, DatastoreOptions datastoreOptions) {
        this.datastoreRpc = datastoreRpc;
        this.protoPreparer = new AggregationQueryRequestProtoPreparer(datastoreOptions);
        this.responseTransformer = new AggregationQueryResponseTransformer();
    }

    @Override
    public AggregationResults execute(AggregationQuery query, ReadOption ... readOptions) {
        RunAggregationQueryRequest runAggregationQueryRequest = this.getRunAggregationQueryRequest(query, readOptions);
        RunAggregationQueryResponse runAggregationQueryResponse = this.datastoreRpc.runAggregationQuery(runAggregationQueryRequest);
        return this.responseTransformer.transform(runAggregationQueryResponse);
    }

    private RunAggregationQueryRequest getRunAggregationQueryRequest(AggregationQuery query, ReadOption ... readOptions) {
        ReadOption.QueryConfig<AggregationQuery> queryConfig = readOptions == null ? ReadOption.QueryConfig.create(query) : ReadOption.QueryConfig.create(query, Arrays.asList(readOptions));
        return this.protoPreparer.prepare(queryConfig);
    }
}

