/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.debugger.v2.stub.Debugger2Stub;
import com.google.cloud.debugger.v2.stub.GrpcDebugger2Stub;
import com.google.cloud.debugger.v2.stub.HttpJsonDebugger2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.clouddebugger.v2.DeleteBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointResponse;
import com.google.devtools.clouddebugger.v2.ListBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.ListDebuggeesRequest;
import com.google.devtools.clouddebugger.v2.ListDebuggeesResponse;
import com.google.devtools.clouddebugger.v2.SetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.SetBreakpointResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class Debugger2StubSettings
extends StubSettings<Debugger2StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud_debugger").build();
    private final UnaryCallSettings<SetBreakpointRequest, SetBreakpointResponse> setBreakpointSettings;
    private final UnaryCallSettings<GetBreakpointRequest, GetBreakpointResponse> getBreakpointSettings;
    private final UnaryCallSettings<DeleteBreakpointRequest, Empty> deleteBreakpointSettings;
    private final UnaryCallSettings<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsSettings;
    private final UnaryCallSettings<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesSettings;

    public UnaryCallSettings<SetBreakpointRequest, SetBreakpointResponse> setBreakpointSettings() {
        return this.setBreakpointSettings;
    }

    public UnaryCallSettings<GetBreakpointRequest, GetBreakpointResponse> getBreakpointSettings() {
        return this.getBreakpointSettings;
    }

    public UnaryCallSettings<DeleteBreakpointRequest, Empty> deleteBreakpointSettings() {
        return this.deleteBreakpointSettings;
    }

    public UnaryCallSettings<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsSettings() {
        return this.listBreakpointsSettings;
    }

    public UnaryCallSettings<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesSettings() {
        return this.listDebuggeesSettings;
    }

    public Debugger2Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDebugger2Stub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDebugger2Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "clouddebugger.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "clouddebugger.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return Debugger2StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(Debugger2StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(Debugger2StubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return Debugger2StubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected Debugger2StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.setBreakpointSettings = settingsBuilder.setBreakpointSettings().build();
        this.getBreakpointSettings = settingsBuilder.getBreakpointSettings().build();
        this.deleteBreakpointSettings = settingsBuilder.deleteBreakpointSettings().build();
        this.listBreakpointsSettings = settingsBuilder.listBreakpointsSettings().build();
        this.listDebuggeesSettings = settingsBuilder.listDebuggeesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<Debugger2StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<SetBreakpointRequest, SetBreakpointResponse> setBreakpointSettings;
        private final UnaryCallSettings.Builder<GetBreakpointRequest, GetBreakpointResponse> getBreakpointSettings;
        private final UnaryCallSettings.Builder<DeleteBreakpointRequest, Empty> deleteBreakpointSettings;
        private final UnaryCallSettings.Builder<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsSettings;
        private final UnaryCallSettings.Builder<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.setBreakpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBreakpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBreakpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBreakpointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDebuggeesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.setBreakpointSettings, this.getBreakpointSettings, this.deleteBreakpointSettings, this.listBreakpointsSettings, this.listDebuggeesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(Debugger2StubSettings settings) {
            super((StubSettings)settings);
            this.setBreakpointSettings = settings.setBreakpointSettings.toBuilder();
            this.getBreakpointSettings = settings.getBreakpointSettings.toBuilder();
            this.deleteBreakpointSettings = settings.deleteBreakpointSettings.toBuilder();
            this.listBreakpointsSettings = settings.listBreakpointsSettings.toBuilder();
            this.listDebuggeesSettings = settings.listDebuggeesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.setBreakpointSettings, this.getBreakpointSettings, this.deleteBreakpointSettings, this.listBreakpointsSettings, this.listDebuggeesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(Debugger2StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)Debugger2StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)Debugger2StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(Debugger2StubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(Debugger2StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)Debugger2StubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)Debugger2StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)Debugger2StubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(Debugger2StubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(Debugger2StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.setBreakpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getBreakpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteBreakpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listBreakpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDebuggeesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<SetBreakpointRequest, SetBreakpointResponse> setBreakpointSettings() {
            return this.setBreakpointSettings;
        }

        public UnaryCallSettings.Builder<GetBreakpointRequest, GetBreakpointResponse> getBreakpointSettings() {
            return this.getBreakpointSettings;
        }

        public UnaryCallSettings.Builder<DeleteBreakpointRequest, Empty> deleteBreakpointSettings() {
            return this.deleteBreakpointSettings;
        }

        public UnaryCallSettings.Builder<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsSettings() {
            return this.listBreakpointsSettings;
        }

        public UnaryCallSettings.Builder<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesSettings() {
            return this.listDebuggeesSettings;
        }

        public Debugger2StubSettings build() throws IOException {
            return new Debugger2StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

