/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.discoveryengine.v1.stub;

import static com.google.cloud.discoveryengine.v1.SchemaServiceClient.ListSchemasPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CreateSchemaMetadata;
import com.google.cloud.discoveryengine.v1.CreateSchemaRequest;
import com.google.cloud.discoveryengine.v1.DeleteSchemaMetadata;
import com.google.cloud.discoveryengine.v1.DeleteSchemaRequest;
import com.google.cloud.discoveryengine.v1.GetSchemaRequest;
import com.google.cloud.discoveryengine.v1.ListSchemasRequest;
import com.google.cloud.discoveryengine.v1.ListSchemasResponse;
import com.google.cloud.discoveryengine.v1.Schema;
import com.google.cloud.discoveryengine.v1.UpdateSchemaMetadata;
import com.google.cloud.discoveryengine.v1.UpdateSchemaRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Settings class to configure an instance of {@link SchemaServiceStub}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (discoveryengine.googleapis.com) and default port (443) are
 *       used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the
 * [RetrySettings](https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings)
 * of getSchema:
 *
 * <pre>{@code
 * // This snippet has been automatically generated and should be regarded as a code template only.
 * // It will require modifications to work:
 * // - It may require correct/in-range values for request initialization.
 * // - It may require specifying regional endpoints when creating the service client as shown in
 * // https://cloud.google.com/java/docs/setup#configure_endpoints_for_the_client_library
 * SchemaServiceStubSettings.Builder schemaServiceSettingsBuilder =
 *     SchemaServiceStubSettings.newBuilder();
 * schemaServiceSettingsBuilder
 *     .getSchemaSettings()
 *     .setRetrySettings(
 *         schemaServiceSettingsBuilder
 *             .getSchemaSettings()
 *             .getRetrySettings()
 *             .toBuilder()
 *             .setInitialRetryDelayDuration(Duration.ofSeconds(1))
 *             .setInitialRpcTimeoutDuration(Duration.ofSeconds(5))
 *             .setMaxAttempts(5)
 *             .setMaxRetryDelayDuration(Duration.ofSeconds(30))
 *             .setMaxRpcTimeoutDuration(Duration.ofSeconds(60))
 *             .setRetryDelayMultiplier(1.3)
 *             .setRpcTimeoutMultiplier(1.5)
 *             .setTotalTimeoutDuration(Duration.ofSeconds(300))
 *             .build());
 * SchemaServiceStubSettings schemaServiceSettings = schemaServiceSettingsBuilder.build();
 * }</pre>
 *
 * Please refer to the [Client Side Retry
 * Guide](https://github.com/googleapis/google-cloud-java/blob/main/docs/client_retries.md) for
 * additional support in setting retries.
 *
 * <p>To configure the RetrySettings of a Long Running Operation method, create an
 * OperationTimedPollAlgorithm object and update the RPC's polling algorithm. For example, to
 * configure the RetrySettings for createSchema:
 *
 * <pre>{@code
 * // This snippet has been automatically generated and should be regarded as a code template only.
 * // It will require modifications to work:
 * // - It may require correct/in-range values for request initialization.
 * // - It may require specifying regional endpoints when creating the service client as shown in
 * // https://cloud.google.com/java/docs/setup#configure_endpoints_for_the_client_library
 * SchemaServiceStubSettings.Builder schemaServiceSettingsBuilder =
 *     SchemaServiceStubSettings.newBuilder();
 * TimedRetryAlgorithm timedRetryAlgorithm =
 *     OperationalTimedPollAlgorithm.create(
 *         RetrySettings.newBuilder()
 *             .setInitialRetryDelayDuration(Duration.ofMillis(500))
 *             .setRetryDelayMultiplier(1.5)
 *             .setMaxRetryDelayDuration(Duration.ofMillis(5000))
 *             .setTotalTimeoutDuration(Duration.ofHours(24))
 *             .build());
 * schemaServiceSettingsBuilder
 *     .createClusterOperationSettings()
 *     .setPollingAlgorithm(timedRetryAlgorithm)
 *     .build();
 * }</pre>
 */
@Generated("by gapic-generator-java")
public class SchemaServiceStubSettings extends StubSettings<SchemaServiceStubSettings> {
  /** The default scopes of the service. */
  private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES =
      ImmutableList.<String>builder().add("https://www.googleapis.com/auth/cloud-platform").build();

  private final UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings;
  private final PagedCallSettings<ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>
      listSchemasSettings;
  private final UnaryCallSettings<CreateSchemaRequest, Operation> createSchemaSettings;
  private final OperationCallSettings<CreateSchemaRequest, Schema, CreateSchemaMetadata>
      createSchemaOperationSettings;
  private final UnaryCallSettings<UpdateSchemaRequest, Operation> updateSchemaSettings;
  private final OperationCallSettings<UpdateSchemaRequest, Schema, UpdateSchemaMetadata>
      updateSchemaOperationSettings;
  private final UnaryCallSettings<DeleteSchemaRequest, Operation> deleteSchemaSettings;
  private final OperationCallSettings<DeleteSchemaRequest, Empty, DeleteSchemaMetadata>
      deleteSchemaOperationSettings;

  private static final PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema>
      LIST_SCHEMAS_PAGE_STR_DESC =
          new PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema>() {
            @Override
            public String emptyToken() {
              return "";
            }

            @Override
            public ListSchemasRequest injectToken(ListSchemasRequest payload, String token) {
              return ListSchemasRequest.newBuilder(payload).setPageToken(token).build();
            }

            @Override
            public ListSchemasRequest injectPageSize(ListSchemasRequest payload, int pageSize) {
              return ListSchemasRequest.newBuilder(payload).setPageSize(pageSize).build();
            }

            @Override
            public Integer extractPageSize(ListSchemasRequest payload) {
              return payload.getPageSize();
            }

            @Override
            public String extractNextToken(ListSchemasResponse payload) {
              return payload.getNextPageToken();
            }

            @Override
            public Iterable<Schema> extractResources(ListSchemasResponse payload) {
              return payload.getSchemasList();
            }
          };

  private static final PagedListResponseFactory<
          ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>
      LIST_SCHEMAS_PAGE_STR_FACT =
          new PagedListResponseFactory<
              ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>() {
            @Override
            public ApiFuture<ListSchemasPagedResponse> getFuturePagedResponse(
                UnaryCallable<ListSchemasRequest, ListSchemasResponse> callable,
                ListSchemasRequest request,
                ApiCallContext context,
                ApiFuture<ListSchemasResponse> futureResponse) {
              PageContext<ListSchemasRequest, ListSchemasResponse, Schema> pageContext =
                  PageContext.create(callable, LIST_SCHEMAS_PAGE_STR_DESC, request, context);
              return ListSchemasPagedResponse.createAsync(pageContext, futureResponse);
            }
          };

  /** Returns the object with the settings used for calls to getSchema. */
  public UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings() {
    return getSchemaSettings;
  }

  /** Returns the object with the settings used for calls to listSchemas. */
  public PagedCallSettings<ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>
      listSchemasSettings() {
    return listSchemasSettings;
  }

  /** Returns the object with the settings used for calls to createSchema. */
  public UnaryCallSettings<CreateSchemaRequest, Operation> createSchemaSettings() {
    return createSchemaSettings;
  }

  /** Returns the object with the settings used for calls to createSchema. */
  public OperationCallSettings<CreateSchemaRequest, Schema, CreateSchemaMetadata>
      createSchemaOperationSettings() {
    return createSchemaOperationSettings;
  }

  /** Returns the object with the settings used for calls to updateSchema. */
  public UnaryCallSettings<UpdateSchemaRequest, Operation> updateSchemaSettings() {
    return updateSchemaSettings;
  }

  /** Returns the object with the settings used for calls to updateSchema. */
  public OperationCallSettings<UpdateSchemaRequest, Schema, UpdateSchemaMetadata>
      updateSchemaOperationSettings() {
    return updateSchemaOperationSettings;
  }

  /** Returns the object with the settings used for calls to deleteSchema. */
  public UnaryCallSettings<DeleteSchemaRequest, Operation> deleteSchemaSettings() {
    return deleteSchemaSettings;
  }

  /** Returns the object with the settings used for calls to deleteSchema. */
  public OperationCallSettings<DeleteSchemaRequest, Empty, DeleteSchemaMetadata>
      deleteSchemaOperationSettings() {
    return deleteSchemaOperationSettings;
  }

  public SchemaServiceStub createStub() throws IOException {
    if (getTransportChannelProvider()
        .getTransportName()
        .equals(GrpcTransportChannel.getGrpcTransportName())) {
      return GrpcSchemaServiceStub.create(this);
    }
    if (getTransportChannelProvider()
        .getTransportName()
        .equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
      return HttpJsonSchemaServiceStub.create(this);
    }
    throw new UnsupportedOperationException(
        String.format(
            "Transport not supported: %s", getTransportChannelProvider().getTransportName()));
  }

  /** Returns the default service name. */
  @Override
  public String getServiceName() {
    return "discoveryengine";
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return InstantiatingExecutorProvider.newBuilder();
  }

  /** Returns the default service endpoint. */
  @ObsoleteApi("Use getEndpoint() instead")
  public static String getDefaultEndpoint() {
    return "discoveryengine.googleapis.com:443";
  }

  /** Returns the default mTLS service endpoint. */
  public static String getDefaultMtlsEndpoint() {
    return "discoveryengine.mtls.googleapis.com:443";
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return DEFAULT_SERVICE_SCOPES;
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return GoogleCredentialsProvider.newBuilder()
        .setScopesToApply(DEFAULT_SERVICE_SCOPES)
        .setUseJwtAccessWithScope(true);
  }

  /** Returns a builder for the default gRPC ChannelProvider for this service. */
  public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
    return InstantiatingGrpcChannelProvider.newBuilder()
        .setMaxInboundMessageSize(Integer.MAX_VALUE);
  }

  /** Returns a builder for the default REST ChannelProvider for this service. */
  @BetaApi
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return InstantiatingHttpJsonChannelProvider.newBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return defaultGrpcTransportProviderBuilder().build();
  }

  public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
    return ApiClientHeaderProvider.newBuilder()
        .setGeneratedLibToken(
            "gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class))
        .setTransportToken(
            GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
  }

  public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
    return ApiClientHeaderProvider.newBuilder()
        .setGeneratedLibToken(
            "gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class))
        .setTransportToken(
            GaxHttpJsonProperties.getHttpJsonTokenName(),
            GaxHttpJsonProperties.getHttpJsonVersion());
  }

  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return SchemaServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
  }

  /** Returns a new gRPC builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new REST builder for this class. */
  public static Builder newHttpJsonBuilder() {
    return Builder.createHttpJsonDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected SchemaServiceStubSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);

    getSchemaSettings = settingsBuilder.getSchemaSettings().build();
    listSchemasSettings = settingsBuilder.listSchemasSettings().build();
    createSchemaSettings = settingsBuilder.createSchemaSettings().build();
    createSchemaOperationSettings = settingsBuilder.createSchemaOperationSettings().build();
    updateSchemaSettings = settingsBuilder.updateSchemaSettings().build();
    updateSchemaOperationSettings = settingsBuilder.updateSchemaOperationSettings().build();
    deleteSchemaSettings = settingsBuilder.deleteSchemaSettings().build();
    deleteSchemaOperationSettings = settingsBuilder.deleteSchemaOperationSettings().build();
  }

  /** Builder for SchemaServiceStubSettings. */
  public static class Builder extends StubSettings.Builder<SchemaServiceStubSettings, Builder> {
    private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
    private final UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings;
    private final PagedCallSettings.Builder<
            ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>
        listSchemasSettings;
    private final UnaryCallSettings.Builder<CreateSchemaRequest, Operation> createSchemaSettings;
    private final OperationCallSettings.Builder<CreateSchemaRequest, Schema, CreateSchemaMetadata>
        createSchemaOperationSettings;
    private final UnaryCallSettings.Builder<UpdateSchemaRequest, Operation> updateSchemaSettings;
    private final OperationCallSettings.Builder<UpdateSchemaRequest, Schema, UpdateSchemaMetadata>
        updateSchemaOperationSettings;
    private final UnaryCallSettings.Builder<DeleteSchemaRequest, Operation> deleteSchemaSettings;
    private final OperationCallSettings.Builder<DeleteSchemaRequest, Empty, DeleteSchemaMetadata>
        deleteSchemaOperationSettings;
    private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>>
        RETRYABLE_CODE_DEFINITIONS;

    static {
      ImmutableMap.Builder<String, ImmutableSet<StatusCode.Code>> definitions =
          ImmutableMap.builder();
      definitions.put(
          "retry_policy_1_codes",
          ImmutableSet.copyOf(Lists.<StatusCode.Code>newArrayList(StatusCode.Code.UNAVAILABLE)));
      RETRYABLE_CODE_DEFINITIONS = definitions.build();
    }

    private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

    static {
      ImmutableMap.Builder<String, RetrySettings> definitions = ImmutableMap.builder();
      RetrySettings settings = null;
      settings =
          RetrySettings.newBuilder()
              .setInitialRetryDelayDuration(Duration.ofMillis(1000L))
              .setRetryDelayMultiplier(1.3)
              .setMaxRetryDelayDuration(Duration.ofMillis(10000L))
              .setInitialRpcTimeoutDuration(Duration.ofMillis(30000L))
              .setRpcTimeoutMultiplier(1.0)
              .setMaxRpcTimeoutDuration(Duration.ofMillis(30000L))
              .setTotalTimeoutDuration(Duration.ofMillis(30000L))
              .build();
      definitions.put("retry_policy_1_params", settings);
      RETRY_PARAM_DEFINITIONS = definitions.build();
    }

    protected Builder() {
      this(((ClientContext) null));
    }

    protected Builder(ClientContext clientContext) {
      super(clientContext);

      getSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
      listSchemasSettings = PagedCallSettings.newBuilder(LIST_SCHEMAS_PAGE_STR_FACT);
      createSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
      createSchemaOperationSettings = OperationCallSettings.newBuilder();
      updateSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
      updateSchemaOperationSettings = OperationCallSettings.newBuilder();
      deleteSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
      deleteSchemaOperationSettings = OperationCallSettings.newBuilder();

      unaryMethodSettingsBuilders =
          ImmutableList.<UnaryCallSettings.Builder<?, ?>>of(
              getSchemaSettings,
              listSchemasSettings,
              createSchemaSettings,
              updateSchemaSettings,
              deleteSchemaSettings);
      initDefaults(this);
    }

    protected Builder(SchemaServiceStubSettings settings) {
      super(settings);

      getSchemaSettings = settings.getSchemaSettings.toBuilder();
      listSchemasSettings = settings.listSchemasSettings.toBuilder();
      createSchemaSettings = settings.createSchemaSettings.toBuilder();
      createSchemaOperationSettings = settings.createSchemaOperationSettings.toBuilder();
      updateSchemaSettings = settings.updateSchemaSettings.toBuilder();
      updateSchemaOperationSettings = settings.updateSchemaOperationSettings.toBuilder();
      deleteSchemaSettings = settings.deleteSchemaSettings.toBuilder();
      deleteSchemaOperationSettings = settings.deleteSchemaOperationSettings.toBuilder();

      unaryMethodSettingsBuilders =
          ImmutableList.<UnaryCallSettings.Builder<?, ?>>of(
              getSchemaSettings,
              listSchemasSettings,
              createSchemaSettings,
              updateSchemaSettings,
              deleteSchemaSettings);
    }

    private static Builder createDefault() {
      Builder builder = new Builder(((ClientContext) null));

      builder.setTransportChannelProvider(defaultTransportChannelProvider());
      builder.setCredentialsProvider(defaultCredentialsProviderBuilder().build());
      builder.setInternalHeaderProvider(defaultApiClientHeaderProviderBuilder().build());
      builder.setMtlsEndpoint(getDefaultMtlsEndpoint());
      builder.setSwitchToMtlsEndpointAllowed(true);

      return initDefaults(builder);
    }

    private static Builder createHttpJsonDefault() {
      Builder builder = new Builder(((ClientContext) null));

      builder.setTransportChannelProvider(defaultHttpJsonTransportProviderBuilder().build());
      builder.setCredentialsProvider(defaultCredentialsProviderBuilder().build());
      builder.setInternalHeaderProvider(defaultHttpJsonApiClientHeaderProviderBuilder().build());
      builder.setMtlsEndpoint(getDefaultMtlsEndpoint());
      builder.setSwitchToMtlsEndpointAllowed(true);

      return initDefaults(builder);
    }

    private static Builder initDefaults(Builder builder) {
      builder
          .getSchemaSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));

      builder
          .listSchemasSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));

      builder
          .createSchemaSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));

      builder
          .updateSchemaSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));

      builder
          .deleteSchemaSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));

      builder
          .createSchemaOperationSettings()
          .setInitialCallSettings(
              UnaryCallSettings
                  .<CreateSchemaRequest, OperationSnapshot>newUnaryCallSettingsBuilder()
                  .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
                  .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"))
                  .build())
          .setResponseTransformer(
              ProtoOperationTransformers.ResponseTransformer.create(Schema.class))
          .setMetadataTransformer(
              ProtoOperationTransformers.MetadataTransformer.create(CreateSchemaMetadata.class))
          .setPollingAlgorithm(
              OperationTimedPollAlgorithm.create(
                  RetrySettings.newBuilder()
                      .setInitialRetryDelayDuration(Duration.ofMillis(5000L))
                      .setRetryDelayMultiplier(1.5)
                      .setMaxRetryDelayDuration(Duration.ofMillis(45000L))
                      .setInitialRpcTimeoutDuration(Duration.ZERO)
                      .setRpcTimeoutMultiplier(1.0)
                      .setMaxRpcTimeoutDuration(Duration.ZERO)
                      .setTotalTimeoutDuration(Duration.ofMillis(300000L))
                      .build()));

      builder
          .updateSchemaOperationSettings()
          .setInitialCallSettings(
              UnaryCallSettings
                  .<UpdateSchemaRequest, OperationSnapshot>newUnaryCallSettingsBuilder()
                  .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
                  .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"))
                  .build())
          .setResponseTransformer(
              ProtoOperationTransformers.ResponseTransformer.create(Schema.class))
          .setMetadataTransformer(
              ProtoOperationTransformers.MetadataTransformer.create(UpdateSchemaMetadata.class))
          .setPollingAlgorithm(
              OperationTimedPollAlgorithm.create(
                  RetrySettings.newBuilder()
                      .setInitialRetryDelayDuration(Duration.ofMillis(5000L))
                      .setRetryDelayMultiplier(1.5)
                      .setMaxRetryDelayDuration(Duration.ofMillis(45000L))
                      .setInitialRpcTimeoutDuration(Duration.ZERO)
                      .setRpcTimeoutMultiplier(1.0)
                      .setMaxRpcTimeoutDuration(Duration.ZERO)
                      .setTotalTimeoutDuration(Duration.ofMillis(300000L))
                      .build()));

      builder
          .deleteSchemaOperationSettings()
          .setInitialCallSettings(
              UnaryCallSettings
                  .<DeleteSchemaRequest, OperationSnapshot>newUnaryCallSettingsBuilder()
                  .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))
                  .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"))
                  .build())
          .setResponseTransformer(
              ProtoOperationTransformers.ResponseTransformer.create(Empty.class))
          .setMetadataTransformer(
              ProtoOperationTransformers.MetadataTransformer.create(DeleteSchemaMetadata.class))
          .setPollingAlgorithm(
              OperationTimedPollAlgorithm.create(
                  RetrySettings.newBuilder()
                      .setInitialRetryDelayDuration(Duration.ofMillis(5000L))
                      .setRetryDelayMultiplier(1.5)
                      .setMaxRetryDelayDuration(Duration.ofMillis(45000L))
                      .setInitialRpcTimeoutDuration(Duration.ZERO)
                      .setRpcTimeoutMultiplier(1.0)
                      .setMaxRpcTimeoutDuration(Duration.ZERO)
                      .setTotalTimeoutDuration(Duration.ofMillis(300000L))
                      .build()));

      return builder;
    }

    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
      super.applyToAllUnaryMethods(unaryMethodSettingsBuilders, settingsUpdater);
      return this;
    }

    public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
      return unaryMethodSettingsBuilders;
    }

    /** Returns the builder for the settings used for calls to getSchema. */
    public UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings() {
      return getSchemaSettings;
    }

    /** Returns the builder for the settings used for calls to listSchemas. */
    public PagedCallSettings.Builder<
            ListSchemasRequest, ListSchemasResponse, ListSchemasPagedResponse>
        listSchemasSettings() {
      return listSchemasSettings;
    }

    /** Returns the builder for the settings used for calls to createSchema. */
    public UnaryCallSettings.Builder<CreateSchemaRequest, Operation> createSchemaSettings() {
      return createSchemaSettings;
    }

    /** Returns the builder for the settings used for calls to createSchema. */
    public OperationCallSettings.Builder<CreateSchemaRequest, Schema, CreateSchemaMetadata>
        createSchemaOperationSettings() {
      return createSchemaOperationSettings;
    }

    /** Returns the builder for the settings used for calls to updateSchema. */
    public UnaryCallSettings.Builder<UpdateSchemaRequest, Operation> updateSchemaSettings() {
      return updateSchemaSettings;
    }

    /** Returns the builder for the settings used for calls to updateSchema. */
    public OperationCallSettings.Builder<UpdateSchemaRequest, Schema, UpdateSchemaMetadata>
        updateSchemaOperationSettings() {
      return updateSchemaOperationSettings;
    }

    /** Returns the builder for the settings used for calls to deleteSchema. */
    public UnaryCallSettings.Builder<DeleteSchemaRequest, Operation> deleteSchemaSettings() {
      return deleteSchemaSettings;
    }

    /** Returns the builder for the settings used for calls to deleteSchema. */
    public OperationCallSettings.Builder<DeleteSchemaRequest, Empty, DeleteSchemaMetadata>
        deleteSchemaOperationSettings() {
      return deleteSchemaOperationSettings;
    }

    @Override
    public SchemaServiceStubSettings build() throws IOException {
      return new SchemaServiceStubSettings(this);
    }
  }
}
