/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSet;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class QuerySnapshot
implements Iterable<QueryDocumentSnapshot> {
    private final Query query;
    private final Timestamp readTime;

    protected QuerySnapshot(Query query, Timestamp readTime) {
        this.query = query;
        this.readTime = readTime;
    }

    public static QuerySnapshot withDocuments(final Query query, Timestamp readTime, final List<QueryDocumentSnapshot> documents) {
        return new QuerySnapshot(query, readTime){
            volatile ImmutableList<DocumentChange> documentChanges;

            @Override
            @Nonnull
            public List<QueryDocumentSnapshot> getDocuments() {
                return Collections.unmodifiableList(documents);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nonnull
            public List<DocumentChange> getDocumentChanges() {
                if (this.documentChanges == null) {
                    List list = documents;
                    synchronized (list) {
                        if (this.documentChanges == null) {
                            int size = documents.size();
                            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
                            for (int i = 0; i < size; ++i) {
                                builder.add((Object)new DocumentChange((QueryDocumentSnapshot)documents.get(i), DocumentChange.Type.ADDED, -1, i));
                            }
                            this.documentChanges = builder.build();
                        }
                    }
                }
                return this.documentChanges;
            }

            @Override
            public int size() {
                return documents.size();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QuerySnapshot that = (QuerySnapshot)o;
                return Objects.equals(query, that.query) && Objects.equals(this.size(), that.size()) && Objects.equals(this.getDocuments(), that.getDocuments());
            }

            @Override
            public int hashCode() {
                return Objects.hash(query, this.getDocuments());
            }
        };
    }

    public static QuerySnapshot withChanges(final Query query, Timestamp readTime, final DocumentSet documentSet, final List<DocumentChange> documentChanges) {
        return new QuerySnapshot(query, readTime){
            volatile List<QueryDocumentSnapshot> documents;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nonnull
            public List<QueryDocumentSnapshot> getDocuments() {
                if (this.documents == null) {
                    DocumentSet documentSet2 = documentSet;
                    synchronized (documentSet2) {
                        if (this.documents == null) {
                            this.documents = documentSet.toList();
                        }
                    }
                }
                return Collections.unmodifiableList(this.documents);
            }

            @Override
            @Nonnull
            public List<DocumentChange> getDocumentChanges() {
                return Collections.unmodifiableList(documentChanges);
            }

            @Override
            public int size() {
                return documentSet.size();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QuerySnapshot that = (QuerySnapshot)o;
                return Objects.equals(query, that.query) && Objects.equals(this.size(), that.size()) && Objects.equals(this.getDocumentChanges(), that.getDocumentChanges()) && Objects.equals(this.getDocuments(), that.getDocuments());
            }

            @Override
            public int hashCode() {
                return Objects.hash(query, this.getDocumentChanges(), this.getDocuments());
            }
        };
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public Timestamp getReadTime() {
        return this.readTime;
    }

    @Nonnull
    public abstract List<QueryDocumentSnapshot> getDocuments();

    @Nonnull
    public abstract List<DocumentChange> getDocumentChanges();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    @Override
    @Nonnull
    public Iterator<QueryDocumentSnapshot> iterator() {
        return this.getDocuments().iterator();
    }

    @Nonnull
    public <T> List<T> toObjects(@Nonnull Class<T> clazz) {
        List<QueryDocumentSnapshot> documents = this.getDocuments();
        ArrayList<T> results = new ArrayList<T>(documents.size());
        for (DocumentSnapshot documentSnapshot : documents) {
            results.add(CustomClassMapper.convertToCustomClass(documentSnapshot.getData(), clazz, documentSnapshot.getReference()));
        }
        return results;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

