/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateRealmRequest;
import com.google.cloud.gaming.v1beta.DeleteRealmRequest;
import com.google.cloud.gaming.v1beta.GetRealmRequest;
import com.google.cloud.gaming.v1beta.ListRealmsRequest;
import com.google.cloud.gaming.v1beta.ListRealmsResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1beta.Realm;
import com.google.cloud.gaming.v1beta.RealmsServiceClient;
import com.google.cloud.gaming.v1beta.UpdateRealmRequest;
import com.google.cloud.gaming.v1beta.stub.HttpJsonRealmsServiceCallableFactory;
import com.google.cloud.gaming.v1beta.stub.RealmsServiceStub;
import com.google.cloud.gaming.v1beta.stub.RealmsServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRealmsServiceStub
extends RealmsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Realm.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListRealmsRequest, ListRealmsResponse> listRealmsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/ListRealms").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/realms", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRealmsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRealmRequest, Realm> getRealmMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/GetRealm").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/realms/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Realm.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateRealmRequest, Operation> createRealmMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/CreateRealm").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/realms", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "realmId", (Object)request.getRealmId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("realm", (Message)request.getRealm(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteRealmRequest, Operation> deleteRealmMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/DeleteRealm").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/realms/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateRealmRequest, Operation> updateRealmMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/UpdateRealm").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{realm.name=projects/*/locations/*/realms/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "realm.name", (Object)request.getRealm().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("realm", (Message)request.getRealm(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gaming.v1beta.RealmsService/PreviewRealmUpdate").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{realm.name=projects/*/locations/*/realms/*}:previewUpdate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "realm.name", (Object)request.getRealm().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "previewTime", (Object)request.getPreviewTime());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("realm", (Message)request.getRealm(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PreviewRealmUpdateResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable;
    private final UnaryCallable<ListRealmsRequest, RealmsServiceClient.ListRealmsPagedResponse> listRealmsPagedCallable;
    private final UnaryCallable<GetRealmRequest, Realm> getRealmCallable;
    private final UnaryCallable<CreateRealmRequest, Operation> createRealmCallable;
    private final OperationCallable<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationCallable;
    private final UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable;
    private final OperationCallable<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationCallable;
    private final UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable;
    private final OperationCallable<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationCallable;
    private final UnaryCallable<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRealmsServiceStub create(RealmsServiceStubSettings settings) throws IOException {
        return new HttpJsonRealmsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRealmsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRealmsServiceStub(RealmsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRealmsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRealmsServiceStub(RealmsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRealmsServiceStub(RealmsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRealmsServiceCallableFactory());
    }

    protected HttpJsonRealmsServiceStub(RealmsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listRealmsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRealmsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRealmTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRealmMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createRealmTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRealmMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteRealmTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRealmMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateRealmTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRealmMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings previewRealmUpdateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(previewRealmUpdateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listRealmsCallable = callableFactory.createUnaryCallable(listRealmsTransportSettings, settings.listRealmsSettings(), clientContext);
        this.listRealmsPagedCallable = callableFactory.createPagedCallable(listRealmsTransportSettings, settings.listRealmsSettings(), clientContext);
        this.getRealmCallable = callableFactory.createUnaryCallable(getRealmTransportSettings, settings.getRealmSettings(), clientContext);
        this.createRealmCallable = callableFactory.createUnaryCallable(createRealmTransportSettings, settings.createRealmSettings(), clientContext);
        this.createRealmOperationCallable = callableFactory.createOperationCallable(createRealmTransportSettings, settings.createRealmOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteRealmCallable = callableFactory.createUnaryCallable(deleteRealmTransportSettings, settings.deleteRealmSettings(), clientContext);
        this.deleteRealmOperationCallable = callableFactory.createOperationCallable(deleteRealmTransportSettings, settings.deleteRealmOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateRealmCallable = callableFactory.createUnaryCallable(updateRealmTransportSettings, settings.updateRealmSettings(), clientContext);
        this.updateRealmOperationCallable = callableFactory.createOperationCallable(updateRealmTransportSettings, settings.updateRealmOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.previewRealmUpdateCallable = callableFactory.createUnaryCallable(previewRealmUpdateTransportSettings, settings.previewRealmUpdateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listRealmsMethodDescriptor);
        methodDescriptors.add(getRealmMethodDescriptor);
        methodDescriptors.add(createRealmMethodDescriptor);
        methodDescriptors.add(deleteRealmMethodDescriptor);
        methodDescriptors.add(updateRealmMethodDescriptor);
        methodDescriptors.add(previewRealmUpdateMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable() {
        return this.listRealmsCallable;
    }

    @Override
    public UnaryCallable<ListRealmsRequest, RealmsServiceClient.ListRealmsPagedResponse> listRealmsPagedCallable() {
        return this.listRealmsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRealmRequest, Realm> getRealmCallable() {
        return this.getRealmCallable;
    }

    @Override
    public UnaryCallable<CreateRealmRequest, Operation> createRealmCallable() {
        return this.createRealmCallable;
    }

    @Override
    public OperationCallable<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationCallable() {
        return this.createRealmOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable() {
        return this.deleteRealmCallable;
    }

    @Override
    public OperationCallable<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationCallable() {
        return this.deleteRealmOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable() {
        return this.updateRealmCallable;
    }

    @Override
    public OperationCallable<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationCallable() {
        return this.updateRealmOperationCallable;
    }

    @Override
    public UnaryCallable<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateCallable() {
        return this.previewRealmUpdateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

