/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.logback;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import java.time.Duration;

public class LogbackBatchingSettings {
    private Long elementCountThreshold = null;
    private Long requestByteThreshold = null;
    private Long delayThreshold = null;
    private Long maxOutstandingElementCount = null;
    private Long maxOutstandingRequestBytes = null;
    private FlowController.LimitExceededBehavior limitExceededBehavior = null;

    public void setElementCountThreshold(Long value) {
        this.elementCountThreshold = value;
    }

    public void setRequestByteThreshold(Long value) {
        this.requestByteThreshold = value;
    }

    public void setDelayThreshold(Long value) {
        this.delayThreshold = value;
    }

    public void setMaxOutstandingElementCount(Long value) {
        this.maxOutstandingElementCount = value;
    }

    public void setMaxOutstandingRequestBytes(Long value) {
        this.maxOutstandingRequestBytes = value;
    }

    public void setLimitExceededBehavior(FlowController.LimitExceededBehavior value) {
        this.limitExceededBehavior = value;
    }

    public BatchingSettings build() {
        BatchingSettings.Builder settings = BatchingSettings.newBuilder();
        if (this.elementCountThreshold != null) {
            settings.setElementCountThreshold(this.elementCountThreshold);
        }
        if (this.requestByteThreshold != null) {
            settings.setRequestByteThreshold(this.requestByteThreshold);
        }
        if (this.delayThreshold != null) {
            settings.setDelayThresholdDuration(Duration.ofMillis(this.delayThreshold));
        }
        if (this.maxOutstandingElementCount != null || this.maxOutstandingRequestBytes != null || this.limitExceededBehavior != null) {
            FlowControlSettings.Builder flowControlSettings = FlowControlSettings.newBuilder();
            flowControlSettings.setMaxOutstandingElementCount(this.maxOutstandingElementCount);
            flowControlSettings.setMaxOutstandingRequestBytes(this.maxOutstandingRequestBytes);
            if (this.limitExceededBehavior != null) {
                flowControlSettings.setLimitExceededBehavior(this.limitExceededBehavior);
            }
            settings.setFlowControlSettings(flowControlSettings.build());
        }
        return settings.build();
    }
}

