/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.OpenTelemetryPubsubTracer;
import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.cloud.pubsub.v1.PubsubMessageWrapper;
import com.google.cloud.pubsub.v1.SequentialExecutorService;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.Waiter;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.TopicNames;
import io.grpc.CallOptions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Publisher
implements PublisherInterface {
    private static final Logger logger = Logger.getLogger(Publisher.class.getName());
    private static final String GZIP_COMPRESSION = "gzip";
    private static final String OPEN_TELEMETRY_TRACER_NAME = "com.google.cloud.pubsub.v1";
    private final String topicName;
    private final int topicNameSize;
    private final TopicName topicNameObject;
    private final BatchingSettings batchingSettings;
    private final boolean enableMessageOrdering;
    private final Lock messagesBatchLock;
    private final Map<String, MessagesBatch> messagesBatches;
    private final AtomicBoolean activeAlarm;
    private final PublisherStub publisherStub;
    private final ScheduledExecutorService executor;
    private final SequentialExecutorService.CallbackExecutor sequentialExecutor;
    private final AtomicBoolean shutdown;
    private final BackgroundResource backgroundResources;
    private final Waiter messagesWaiter;
    private ScheduledFuture<?> currentAlarmFuture;
    private final ApiFunction<PubsubMessage, PubsubMessage> messageTransform;
    private MessageFlowController flowController = null;
    private final boolean enableCompression;
    private final long compressionBytesThreshold;
    private final GrpcCallContext publishContext;
    private final GrpcCallContext publishContextWithCompression;
    private final boolean enableOpenTelemetryTracing;
    private final OpenTelemetry openTelemetry;
    private OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(null, false);

    public static long getApiMaxRequestElementCount() {
        return 1000L;
    }

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private Publisher(Builder builder) throws IOException {
        RetrySettings.Builder retrySettingsBuilder;
        Tracer openTelemetryTracer;
        this.topicName = builder.topicName;
        this.topicNameSize = CodedOutputStream.computeStringSize((int)1, (String)this.topicName);
        this.topicNameObject = TopicName.parse((String)this.topicName);
        this.batchingSettings = builder.batchingSettings;
        FlowControlSettings flowControl = this.batchingSettings.getFlowControlSettings();
        if (flowControl != null && flowControl.getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore) {
            this.flowController = new MessageFlowController(flowControl.getMaxOutstandingElementCount(), flowControl.getMaxOutstandingRequestBytes(), flowControl.getLimitExceededBehavior());
        }
        this.enableMessageOrdering = builder.enableMessageOrdering;
        this.messageTransform = builder.messageTransform;
        this.enableCompression = builder.enableCompression;
        this.compressionBytesThreshold = builder.compressionBytesThreshold;
        this.enableOpenTelemetryTracing = builder.enableOpenTelemetryTracing;
        this.openTelemetry = builder.openTelemetry;
        if (this.openTelemetry != null && this.enableOpenTelemetryTracing && (openTelemetryTracer = builder.openTelemetry.getTracer(OPEN_TELEMETRY_TRACER_NAME)) != null) {
            this.tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, this.enableOpenTelemetryTracing);
        }
        this.messagesBatches = new HashMap<String, MessagesBatch>();
        this.messagesBatchLock = new ReentrantLock();
        this.activeAlarm = new AtomicBoolean(false);
        this.executor = builder.executorProvider.getExecutor();
        this.sequentialExecutor = new SequentialExecutorService.CallbackExecutor(this.executor);
        ArrayList<Object> backgroundResourceList = new ArrayList<Object>();
        if (builder.executorProvider.shouldAutoClose()) {
            backgroundResourceList.add(new ExecutorAsBackgroundResource((ExecutorService)this.executor));
        }
        if ((retrySettingsBuilder = builder.retrySettings.toBuilder()).getMaxAttempts() == 0) {
            retrySettingsBuilder.setMaxAttempts(Integer.MAX_VALUE);
        }
        if (this.enableMessageOrdering) {
            retrySettingsBuilder.setMaxAttempts(Integer.MAX_VALUE).setTotalTimeoutDuration(Duration.ofNanos(Long.MAX_VALUE));
        }
        PublisherStubSettings.Builder stubSettings = (PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)PublisherStubSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.executor))).setTransportChannelProvider(builder.channelProvider)).setEndpoint(builder.endpoint)).setUniverseDomain(builder.universeDomain)).setHeaderProvider(builder.headerProvider);
        stubSettings.publishSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNKNOWN, StatusCode.Code.UNAVAILABLE}).setRetrySettings(retrySettingsBuilder.build()).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(false)).build());
        this.publisherStub = GrpcPublisherStub.create(stubSettings.build());
        backgroundResourceList.add(this.publisherStub);
        this.backgroundResources = new BackgroundResourceAggregation(backgroundResourceList);
        this.shutdown = new AtomicBoolean(false);
        this.messagesWaiter = new Waiter();
        this.publishContext = GrpcCallContext.createDefault();
        this.publishContextWithCompression = GrpcCallContext.createDefault().withCallOptions(CallOptions.DEFAULT.withCompression(GZIP_COMPRESSION));
    }

    public TopicName getTopicName() {
        return TopicNames.parse((String)this.topicName);
    }

    public String getTopicNameString() {
        return this.topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<String> publish(PubsubMessage message) {
        List batchesToSend;
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot publish on a shut-down publisher.");
        String orderingKey = message.getOrderingKey();
        Preconditions.checkState((orderingKey.isEmpty() || this.enableMessageOrdering ? 1 : 0) != 0, (Object)"Cannot publish a message with an ordering key when message ordering is not enabled in the Publisher client. Please create a Publisher client with setEnableMessageOrdering(true) in the builder.");
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.messageTransform.apply((Object)message), this.topicNameObject).build();
        this.tracer.startPublisherSpan(messageWrapper);
        OutstandingPublish outstandingPublish = new OutstandingPublish(messageWrapper);
        if (this.flowController != null) {
            this.tracer.startPublishFlowControlSpan(messageWrapper);
            try {
                this.flowController.acquire(outstandingPublish.messageSize);
                this.tracer.endPublishFlowControlSpan(messageWrapper);
            }
            catch (FlowController.FlowControlException e) {
                if (!orderingKey.isEmpty()) {
                    this.sequentialExecutor.stopPublish(orderingKey);
                }
                outstandingPublish.publishResult.setException((Throwable)e);
                this.tracer.setPublishFlowControlSpanException(messageWrapper, e);
                return outstandingPublish.publishResult;
            }
        }
        this.messagesBatchLock.lock();
        try {
            this.tracer.startPublishBatchingSpan(messageWrapper);
            if (!orderingKey.isEmpty() && this.sequentialExecutor.keyHasError(orderingKey)) {
                outstandingPublish.publishResult.setException((Throwable)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION);
                SettableApiFuture<String> settableApiFuture = outstandingPublish.publishResult;
                return settableApiFuture;
            }
            MessagesBatch messagesBatch = this.messagesBatches.get(orderingKey);
            if (messagesBatch == null) {
                messagesBatch = new MessagesBatch(this.batchingSettings, this.topicNameSize, orderingKey);
                this.messagesBatches.put(orderingKey, messagesBatch);
            }
            if (!(batchesToSend = messagesBatch.add(outstandingPublish)).isEmpty() && messagesBatch.isEmpty()) {
                this.messagesBatches.remove(orderingKey);
            }
            this.setupAlarm();
            if (!batchesToSend.isEmpty() && !orderingKey.isEmpty()) {
                for (OutstandingBatch batch : batchesToSend) {
                    logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
                    this.publishOutstandingBatch(batch);
                }
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.messagesWaiter.incrementPendingCount(1);
        if (!batchesToSend.isEmpty() && orderingKey.isEmpty()) {
            for (final OutstandingBatch batch : batchesToSend) {
                logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Publisher.this.publishOutstandingBatch(batch);
                    }
                });
            }
        }
        return outstandingPublish.publishResult;
    }

    public void resumePublish(String key) {
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot publish on a shut-down publisher.");
        this.sequentialExecutor.resumePublish(key);
    }

    private void setupAlarm() {
        if (!this.messagesBatches.isEmpty()) {
            if (!this.activeAlarm.getAndSet(true)) {
                long delayThresholdMs = this.getBatchingSettings().getDelayThreshold().toMillis();
                logger.log(Level.FINER, "Setting up alarm for the next {0} ms.", delayThresholdMs);
                this.currentAlarmFuture = this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        logger.log(Level.FINER, "Sending messages based on schedule.");
                        Publisher.this.activeAlarm.getAndSet(false);
                        Publisher.this.publishAllWithoutInflight();
                    }
                }, delayThresholdMs, TimeUnit.MILLISECONDS);
            }
        } else if (this.currentAlarmFuture != null) {
            logger.log(Level.FINER, "Cancelling alarm, no more messages");
            if (this.activeAlarm.getAndSet(false)) {
                this.currentAlarmFuture.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAllOutstanding() {
        OutstandingBatch unorderedOutstandingBatch = null;
        this.messagesBatchLock.lock();
        try {
            for (MessagesBatch batch : this.messagesBatches.values()) {
                if (batch.isEmpty()) continue;
                if (!batch.orderingKey.isEmpty()) {
                    this.publishOutstandingBatch(batch.popOutstandingBatch());
                    continue;
                }
                unorderedOutstandingBatch = batch.popOutstandingBatch();
            }
            this.messagesBatches.clear();
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        if (unorderedOutstandingBatch != null) {
            this.publishOutstandingBatch(unorderedOutstandingBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAllWithoutInflight() {
        OutstandingBatch unorderedOutstandingBatch = null;
        this.messagesBatchLock.lock();
        try {
            Iterator<Map.Entry<String, MessagesBatch>> it = this.messagesBatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, MessagesBatch> entry = it.next();
                MessagesBatch batch = entry.getValue();
                String key = entry.getKey();
                if (batch.isEmpty()) {
                    it.remove();
                    continue;
                }
                if (key.isEmpty()) {
                    unorderedOutstandingBatch = batch.popOutstandingBatch();
                    it.remove();
                    continue;
                }
                if (this.sequentialExecutor.hasTasksInflight(key)) continue;
                this.publishOutstandingBatch(batch.popOutstandingBatch());
                it.remove();
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        if (unorderedOutstandingBatch != null) {
            this.publishOutstandingBatch(unorderedOutstandingBatch);
        }
    }

    private void publishAllWithoutInflightForKey(String orderingKey) {
        this.messagesBatchLock.lock();
        try {
            MessagesBatch batch = this.messagesBatches.get(orderingKey);
            if (batch != null && !this.sequentialExecutor.hasTasksInflight(orderingKey)) {
                this.publishOutstandingBatch(batch.popOutstandingBatch());
                this.messagesBatches.remove(orderingKey);
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
    }

    private ApiFuture<PublishResponse> publishCall(OutstandingBatch outstandingBatch) {
        GrpcCallContext context = this.publishContext;
        if (this.enableCompression && (long)outstandingBatch.batchSizeBytes >= this.compressionBytesThreshold) {
            context = this.publishContextWithCompression;
        }
        int numMessagesInBatch = outstandingBatch.size();
        ArrayList<PubsubMessage> pubsubMessagesList = new ArrayList<PubsubMessage>(numMessagesInBatch);
        List messageWrappers = outstandingBatch.getMessageWrappers();
        for (PubsubMessageWrapper messageWrapper : messageWrappers) {
            this.tracer.endPublishBatchingSpan(messageWrapper);
            pubsubMessagesList.add(messageWrapper.getPubsubMessage());
        }
        outstandingBatch.publishRpcSpan = this.tracer.startPublishRpcSpan(this.topicNameObject, messageWrappers);
        return this.publisherStub.publishCallable().futureCall((Object)PublishRequest.newBuilder().setTopic(this.topicName).addAllMessages(pubsubMessagesList).build(), (ApiCallContext)context);
    }

    private void publishOutstandingBatch(final OutstandingBatch outstandingBatch) {
        if (outstandingBatch.size() == 0) {
            logger.log(Level.WARNING, "Attempted to publish batch with zero messages.");
            return;
        }
        ApiFutureCallback<PublishResponse> futureCallback = new ApiFutureCallback<PublishResponse>(){

            public void onSuccess(PublishResponse result) {
                try {
                    if (result == null || result.getMessageIdsCount() != outstandingBatch.size()) {
                        outstandingBatch.onFailure(new IllegalStateException(String.format("The publish result count %s does not match the expected %s results. Please contact Cloud Pub/Sub support if this frequently occurs", result.getMessageIdsCount(), outstandingBatch.size())));
                    } else {
                        outstandingBatch.onSuccess((Iterable)result.getMessageIdsList());
                        if (!Publisher.this.activeAlarm.get() && outstandingBatch.orderingKey != null && !outstandingBatch.orderingKey.isEmpty()) {
                            Publisher.this.publishAllWithoutInflightForKey(outstandingBatch.orderingKey);
                        }
                    }
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingCount(-outstandingBatch.size());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                try {
                    if (outstandingBatch.orderingKey != null && !outstandingBatch.orderingKey.isEmpty()) {
                        Publisher.this.messagesBatchLock.lock();
                        try {
                            MessagesBatch messagesBatch = (MessagesBatch)Publisher.this.messagesBatches.get(outstandingBatch.orderingKey);
                            if (messagesBatch != null) {
                                for (OutstandingPublish outstanding : messagesBatch.messages) {
                                    outstanding.publishResult.setException((Throwable)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION);
                                }
                                Publisher.this.messagesBatches.remove(outstandingBatch.orderingKey);
                            }
                        }
                        finally {
                            Publisher.this.messagesBatchLock.unlock();
                        }
                    }
                    outstandingBatch.onFailure(t);
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingCount(-outstandingBatch.size());
                }
            }
        };
        ApiFuture<PublishResponse> future = outstandingBatch.orderingKey == null || outstandingBatch.orderingKey.isEmpty() ? this.publishCall(outstandingBatch) : this.sequentialExecutor.submit(outstandingBatch.orderingKey, new Callable<ApiFuture<PublishResponse>>(){

            @Override
            public ApiFuture<PublishResponse> call() {
                return Publisher.this.publishCall(outstandingBatch);
            }
        });
        ApiFutures.addCallback(future, (ApiFutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    public void shutdown() {
        Preconditions.checkState((!this.shutdown.getAndSet(true) ? 1 : 0) != 0, (Object)"Cannot shut down a publisher already shut-down.");
        if (this.currentAlarmFuture != null && this.activeAlarm.getAndSet(false)) {
            this.currentAlarmFuture.cancel(false);
        }
        this.publishAllOutstanding();
        this.messagesWaiter.waitComplete();
        this.backgroundResources.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }

    public static Builder newBuilder(TopicName topicName) {
        return Publisher.newBuilder(topicName.toString());
    }

    public static Builder newBuilder(String topicName) {
        return new Builder(topicName);
    }

    public static final class Builder {
        static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds(10L);
        static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis(10L);
        static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
        static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 1000L;
        static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis(1L);
        private static final Duration DEFAULT_INITIAL_RPC_TIMEOUT = Duration.ofSeconds(5L);
        private static final Duration DEFAULT_MAX_RPC_TIMEOUT = Duration.ofSeconds(60L);
        private static final Duration DEFAULT_TOTAL_TIMEOUT = Duration.ofSeconds(600L);
        private static final Duration DEFAULT_INITIAL_RETRY_DELAY = Duration.ofMillis(100L);
        private static final Duration DEFAULT_MAX_RETRY_DELAY = Duration.ofSeconds(60L);
        private static final double DEFAULT_MULTIPLIER = 4.0;
        static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThresholdDuration(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(Long.valueOf(1000L)).setElementCountThreshold(Long.valueOf(100L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build()).build();
        static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setTotalTimeoutDuration(DEFAULT_TOTAL_TIMEOUT).setInitialRetryDelayDuration(DEFAULT_INITIAL_RETRY_DELAY).setRetryDelayMultiplier(4.0).setMaxRetryDelayDuration(DEFAULT_MAX_RETRY_DELAY).setInitialRpcTimeoutDuration(DEFAULT_INITIAL_RPC_TIMEOUT).setRpcTimeoutMultiplier(4.0).setMaxRpcTimeoutDuration(DEFAULT_MAX_RPC_TIMEOUT).build();
        static final boolean DEFAULT_ENABLE_MESSAGE_ORDERING = false;
        private static final int THREADS_PER_CPU = 5;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        static final boolean DEFAULT_ENABLE_COMPRESSION = false;
        static final long DEFAULT_COMPRESSION_BYTES_THRESHOLD = 240L;
        String topicName;
        private String endpoint = null;
        private String universeDomain = null;
        BatchingSettings batchingSettings = DEFAULT_BATCHING_SETTINGS;
        RetrySettings retrySettings = DEFAULT_RETRY_SETTINGS;
        private boolean enableMessageOrdering = false;
        private TransportChannelProvider channelProvider = TopicAdminSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private HeaderProvider headerProvider = new NoHeaderProvider();
        private HeaderProvider internalHeaderProvider = TopicAdminSettings.defaultApiClientHeaderProviderBuilder().build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        private CredentialsProvider credentialsProvider = TopicAdminSettings.defaultCredentialsProviderBuilder().build();
        private ApiFunction<PubsubMessage, PubsubMessage> messageTransform = new ApiFunction<PubsubMessage, PubsubMessage>(){

            public PubsubMessage apply(PubsubMessage input) {
                return input;
            }
        };
        private boolean enableCompression = false;
        private long compressionBytesThreshold = 240L;
        private boolean enableOpenTelemetryTracing = false;
        private OpenTelemetry openTelemetry = null;

        private Builder(String topic) {
            this.topicName = (String)Preconditions.checkNotNull((Object)topic);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = (HeaderProvider)Preconditions.checkNotNull((Object)internalHeaderProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            Preconditions.checkNotNull((Object)batchingSettings);
            Preconditions.checkNotNull((Object)batchingSettings.getElementCountThreshold());
            Preconditions.checkArgument((batchingSettings.getElementCountThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getRequestByteThreshold());
            Preconditions.checkArgument((batchingSettings.getRequestByteThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getDelayThreshold());
            Preconditions.checkArgument((batchingSettings.getDelayThreshold().toMillis() > 0L ? 1 : 0) != 0);
            FlowControlSettings flowControlSettings = batchingSettings.getFlowControlSettings();
            if (flowControlSettings.getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore) {
                Preconditions.checkArgument((flowControlSettings.getMaxOutstandingElementCount() > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((flowControlSettings.getMaxOutstandingRequestBytes() > 0L ? 1 : 0) != 0);
            }
            this.batchingSettings = batchingSettings;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            Preconditions.checkArgument((retrySettings.getTotalTimeoutDuration().compareTo(MIN_TOTAL_TIMEOUT) >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((retrySettings.getInitialRpcTimeoutDuration().compareTo(MIN_RPC_TIMEOUT) >= 0 ? 1 : 0) != 0);
            this.retrySettings = retrySettings;
            return this;
        }

        public Builder setEnableMessageOrdering(boolean enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        @BetaApi
        public Builder setTransform(ApiFunction<PubsubMessage, PubsubMessage> messageTransform) {
            this.messageTransform = (ApiFunction)Preconditions.checkNotNull(messageTransform, (Object)"The messageTransform cannnot be null.");
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public Builder setEnableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return this;
        }

        public Builder setCompressionBytesThreshold(long compressionBytesThreshold) {
            this.compressionBytesThreshold = compressionBytesThreshold;
            return this;
        }

        public Builder setEnableOpenTelemetryTracing(boolean enableOpenTelemetryTracing) {
            this.enableOpenTelemetryTracing = enableOpenTelemetryTracing;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public static BatchingSettings getDefaultBatchingSettings() {
            return DEFAULT_BATCHING_SETTINGS;
        }

        public Publisher build() throws IOException {
            return new Publisher(this);
        }
    }

    private static class MessageFlowController {
        private final Lock lock;
        private final Long messageLimit;
        private final Long byteLimit;
        private final FlowController.LimitExceededBehavior limitBehavior;
        private Long outstandingMessages;
        private Long outstandingBytes;
        private LinkedList<CountDownLatch> awaitingMessageAcquires;
        private LinkedList<CountDownLatch> awaitingBytesAcquires;

        MessageFlowController(Long messageLimit, Long byteLimit, FlowController.LimitExceededBehavior limitBehavior) {
            this.messageLimit = messageLimit;
            this.byteLimit = byteLimit;
            this.limitBehavior = limitBehavior;
            this.lock = new ReentrantLock();
            this.outstandingMessages = 0L;
            this.outstandingBytes = 0L;
            this.awaitingMessageAcquires = new LinkedList();
            this.awaitingBytesAcquires = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acquire(long messageSize) throws FlowController.FlowControlException {
            if (messageSize > this.byteLimit) {
                logger.log(Level.WARNING, "Attempted to publish message with byte size > request byte flow control limit.");
                throw new FlowController.MaxOutstandingRequestBytesReachedException(this.byteLimit.longValue());
            }
            this.lock.lock();
            try {
                if (this.outstandingMessages >= this.messageLimit && this.limitBehavior == FlowController.LimitExceededBehavior.ThrowException) {
                    throw new FlowController.MaxOutstandingElementCountReachedException(this.messageLimit.longValue());
                }
                if (this.outstandingBytes + messageSize >= this.byteLimit && this.limitBehavior == FlowController.LimitExceededBehavior.ThrowException) {
                    throw new FlowController.MaxOutstandingRequestBytesReachedException(this.byteLimit.longValue());
                }
                CountDownLatch messageWaiter = null;
                while (this.outstandingMessages >= this.messageLimit) {
                    if (messageWaiter == null) {
                        messageWaiter = new CountDownLatch(1);
                        this.awaitingMessageAcquires.addLast(messageWaiter);
                    } else {
                        messageWaiter = new CountDownLatch(1);
                        this.awaitingMessageAcquires.set(0, messageWaiter);
                    }
                    this.lock.unlock();
                    try {
                        messageWaiter.await();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Interrupted while waiting to acquire flow control tokens");
                    }
                    this.lock.lock();
                }
                this.outstandingMessages = this.outstandingMessages + 1L;
                if (messageWaiter != null) {
                    this.awaitingMessageAcquires.removeFirst();
                }
                if (!this.awaitingMessageAcquires.isEmpty() && this.outstandingMessages < this.messageLimit) {
                    this.awaitingMessageAcquires.getFirst().countDown();
                }
                CountDownLatch bytesWaiter = null;
                Long bytesRemaining = messageSize;
                while (this.outstandingBytes + bytesRemaining >= this.byteLimit) {
                    Long available = this.byteLimit - this.outstandingBytes;
                    bytesRemaining = bytesRemaining - available;
                    this.outstandingBytes = this.byteLimit;
                    if (bytesWaiter == null) {
                        bytesWaiter = new CountDownLatch(1);
                        this.awaitingBytesAcquires.addLast(bytesWaiter);
                    } else {
                        bytesWaiter = new CountDownLatch(1);
                        this.awaitingBytesAcquires.set(0, bytesWaiter);
                    }
                    this.lock.unlock();
                    try {
                        bytesWaiter.await();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Interrupted while waiting to acquire flow control tokens");
                    }
                    this.lock.lock();
                }
                this.outstandingBytes = this.outstandingBytes + bytesRemaining;
                if (bytesWaiter != null) {
                    this.awaitingBytesAcquires.removeFirst();
                }
                if (!this.awaitingBytesAcquires.isEmpty() && this.outstandingBytes < this.byteLimit) {
                    this.awaitingBytesAcquires.getFirst().countDown();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void notifyNextAcquires() {
            CountDownLatch awaitingAcquire;
            if (!this.awaitingMessageAcquires.isEmpty()) {
                awaitingAcquire = this.awaitingMessageAcquires.getFirst();
                awaitingAcquire.countDown();
            }
            if (!this.awaitingBytesAcquires.isEmpty()) {
                awaitingAcquire = this.awaitingBytesAcquires.getFirst();
                awaitingAcquire.countDown();
            }
        }

        void release(long messageSize) {
            this.lock.lock();
            this.outstandingMessages = this.outstandingMessages - 1L;
            this.outstandingBytes = this.outstandingBytes - messageSize;
            this.notifyNextAcquires();
            this.lock.unlock();
        }
    }

    private final class OutstandingBatch {
        final List<OutstandingPublish> outstandingPublishes;
        final long creationTime;
        int attempt;
        int batchSizeBytes;
        final String orderingKey;
        Span publishRpcSpan;

        OutstandingBatch(List<OutstandingPublish> outstandingPublishes, int batchSizeBytes, String orderingKey) {
            this.outstandingPublishes = outstandingPublishes;
            this.attempt = 1;
            this.creationTime = System.currentTimeMillis();
            this.batchSizeBytes = batchSizeBytes;
            this.orderingKey = orderingKey;
        }

        int size() {
            return this.outstandingPublishes.size();
        }

        private List<PubsubMessageWrapper> getMessageWrappers() {
            ArrayList<PubsubMessageWrapper> results = new ArrayList<PubsubMessageWrapper>(this.outstandingPublishes.size());
            for (OutstandingPublish outstandingPublish : this.outstandingPublishes) {
                results.add(outstandingPublish.messageWrapper);
            }
            return results;
        }

        private void onFailure(Throwable t) {
            Publisher.this.tracer.setPublishRpcSpanException(this.publishRpcSpan, t);
            for (OutstandingPublish outstandingPublish : this.outstandingPublishes) {
                if (Publisher.this.flowController != null) {
                    Publisher.this.flowController.release(outstandingPublish.messageSize);
                }
                outstandingPublish.publishResult.setException(t);
                Publisher.this.tracer.endPublisherSpan(outstandingPublish.messageWrapper);
            }
        }

        private void onSuccess(Iterable<String> results) {
            Publisher.this.tracer.endPublishRpcSpan(this.publishRpcSpan);
            Iterator<OutstandingPublish> messagesResultsIt = this.outstandingPublishes.iterator();
            for (String messageId : results) {
                OutstandingPublish nextPublish = messagesResultsIt.next();
                if (Publisher.this.flowController != null) {
                    Publisher.this.flowController.release(nextPublish.messageSize);
                }
                nextPublish.publishResult.set((Object)messageId);
                Publisher.this.tracer.setPublisherMessageIdSpanAttribute(nextPublish.messageWrapper, messageId);
                Publisher.this.tracer.endPublisherSpan(nextPublish.messageWrapper);
            }
        }
    }

    private static final class OutstandingPublish {
        final SettableApiFuture<String> publishResult = SettableApiFuture.create();
        final PubsubMessageWrapper messageWrapper;
        final int messageSize;

        OutstandingPublish(PubsubMessageWrapper messageWrapper) {
            this.messageWrapper = messageWrapper;
            this.messageSize = CodedOutputStream.computeMessageSize((int)2, (MessageLite)messageWrapper.getPubsubMessage());
        }
    }

    private class MessagesBatch {
        private List<OutstandingPublish> messages;
        private int initialBatchedBytes;
        private int batchedBytes;
        private String orderingKey;
        private final BatchingSettings batchingSettings;

        private MessagesBatch(BatchingSettings batchingSettings, int initialBatchedBytes, String orderingKey) {
            this.batchingSettings = batchingSettings;
            this.initialBatchedBytes = initialBatchedBytes;
            this.orderingKey = orderingKey;
            this.reset();
        }

        private OutstandingBatch popOutstandingBatch() {
            OutstandingBatch batch = new OutstandingBatch(this.messages, this.batchedBytes, this.orderingKey);
            this.reset();
            return batch;
        }

        private void reset() {
            this.messages = new LinkedList<OutstandingPublish>();
            this.batchedBytes = this.initialBatchedBytes;
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        private int getBatchedBytes() {
            return this.batchedBytes;
        }

        private int getMessagesCount() {
            return this.messages.size();
        }

        private boolean hasBatchingBytes() {
            return this.getMaxBatchBytes() > 0L;
        }

        private long getMaxBatchBytes() {
            return this.batchingSettings.getRequestByteThreshold();
        }

        private List<OutstandingBatch> add(OutstandingPublish outstandingPublish) {
            ArrayList<OutstandingBatch> batchesToSend = new ArrayList<OutstandingBatch>();
            if (!this.isEmpty() && this.hasBatchingBytes() && (long)(this.getBatchedBytes() + outstandingPublish.messageSize) >= this.getMaxBatchBytes()) {
                batchesToSend.add(this.popOutstandingBatch());
            }
            this.messages.add(outstandingPublish);
            this.batchedBytes += outstandingPublish.messageSize;
            if (this.hasBatchingBytes() && (long)this.getBatchedBytes() >= this.getMaxBatchBytes() || (long)this.getMessagesCount() == this.batchingSettings.getElementCountThreshold()) {
                batchesToSend.add(this.popOutstandingBatch());
            }
            return batchesToSend;
        }
    }
}

