/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_ReservationPath;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectBuilderHelper;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.ReservationName;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import java.io.Serializable;
import java.util.Arrays;

@AutoValue
public abstract class ReservationPath
implements Serializable {
    public abstract ProjectIdOrNumber project();

    public abstract CloudRegion location();

    public abstract ReservationName name();

    public LocationPath locationPath() {
        return ((LocationPath.Builder)((LocationPath.Builder)LocationPath.newBuilder().setProject(this.project())).setLocation(this.location())).build();
    }

    public String toString() {
        return this.locationPath() + "/reservations/" + this.name();
    }

    public static Builder newBuilder() {
        return new AutoValue_ReservationPath.Builder();
    }

    public abstract Builder toBuilder();

    public static ReservationPath parse(String path) throws ApiException {
        String[] splits = path.split("/");
        UncheckedApiPreconditions.checkArgument(splits.length == 6, "Not a valid reservation path: " + path);
        UncheckedApiPreconditions.checkArgument(splits[4].equals("reservations"), "Not a valid reservation path: " + path);
        LocationPath location = LocationPath.parse(String.join((CharSequence)"/", Arrays.copyOf(splits, 4)));
        UncheckedApiPreconditions.checkArgument(location.location().getKind() == CloudRegionOrZone.Kind.REGION, "Reservation location must be a valid cloud region.");
        return ((Builder)ReservationPath.newBuilder().setProject(location.project())).setLocation(location.location().region()).setName(ReservationName.of(splits[5])).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ProjectBuilderHelper<Builder> {
        public abstract Builder setLocation(CloudRegion var1);

        public abstract Builder setName(ReservationName var1);

        public abstract ReservationPath build();
    }
}

